/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.utils.osgi.autostart;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import org.eclipse.scada.utils.str.StringReplacer;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.startlevel.BundleStartLevel;
import org.osgi.framework.startlevel.FrameworkStartLevel;
import org.osgi.service.log.LogService;

public class Activator
implements BundleActivator {
    private BundleContext context;
    private int defaultStartLevel = 4;
    private final Map<String, Integer> bundleStartList = new LinkedHashMap<String, Integer>();

    public void start(BundleContext bundleContext) throws Exception {
        FrameworkStartLevel service;
        this.context = bundleContext;
        ServiceReference frameworkStartLevel = this.context.getServiceReference(FrameworkStartLevel.class);
        if (frameworkStartLevel != null && (service = (FrameworkStartLevel)this.context.getService(frameworkStartLevel)) != null) {
            try {
                this.defaultStartLevel = service.getInitialBundleStartLevel();
            }
            finally {
                this.context.ungetService(frameworkStartLevel);
            }
        }
        this.loadStartLevels();
        for (Map.Entry<String, Integer> entry : this.bundleStartList.entrySet()) {
            this.setStartLevel(entry.getKey(), entry.getValue());
        }
    }

    protected void log(int level, String message) {
        BundleContext context = this.context;
        if (context == null) {
            return;
        }
        ServiceReference ref = context.getServiceReference(LogService.class);
        if (ref == null) {
            return;
        }
        LogService service = (LogService)context.getService(ref);
        if (service == null) {
            return;
        }
        try {
            service.log(level, message);
        }
        finally {
            context.ungetService(ref);
        }
    }

    protected void loadStartLevels() throws IOException {
        String location = System.getProperty("org.eclipse.scada.utils.osgi.autostart.url", null);
        location = StringReplacer.replace((String)location, (Map)System.getProperties());
        String fileLocation = System.getProperty("org.eclipse.scada.utils.osgi.autostart.file", null);
        if (fileLocation != null) {
            fileLocation = StringReplacer.replace((String)fileLocation, (Map)System.getProperties());
            location = new File(fileLocation).toURI().toURL().toString();
        }
        this.log(3, String.format("Loading start bundles from: %s", location));
        this.bundleStartList.clear();
        if (location == null) {
            return;
        }
        URL url = new URL(location);
        Properties p = new Properties();
        Throwable throwable = null;
        Iterator<String> iterator = null;
        try (InputStream input = url.openStream();){
            p.load(input);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        for (String key : p.stringPropertyNames()) {
            String value = p.getProperty(key);
            this.bundleStartList.put(key, Integer.parseInt(value));
        }
    }

    private void setStartLevel(String symbolicName, int startLevel) throws BundleException {
        Bundle bundle = this.findBundle(symbolicName);
        if (bundle == null) {
            return;
        }
        BundleStartLevel bundleStartLevel = (BundleStartLevel)bundle.adapt(BundleStartLevel.class);
        if (bundleStartLevel == null) {
            return;
        }
        bundleStartLevel.setStartLevel(startLevel < 0 ? this.defaultStartLevel : startLevel);
        bundle.start();
    }

    private Bundle findBundle(String symbolicName) {
        Bundle[] bundles = this.context.getBundles();
        if (bundles == null) {
            return null;
        }
        Bundle[] bundleArray = bundles;
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle bundle = bundleArray[n2];
            if (bundle.getSymbolicName().equals(symbolicName)) {
                return bundle;
            }
            ++n2;
        }
        return null;
    }

    public void stop(BundleContext bundleContext) throws Exception {
        this.context = null;
    }
}

