/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.base.extractor.mqtt.input;

import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.eclipse.paho.client.mqttv3.IMqttActionListener;
import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.IMqttToken;
import org.eclipse.paho.client.mqttv3.MqttAsyncClient;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.MqttPingSender;
import org.eclipse.paho.client.mqttv3.TimerPingSender;
import org.eclipse.paho.client.mqttv3.persist.MemoryPersistence;
import org.eclipse.scada.base.extractor.input.AbstractInput;
import org.eclipse.scada.base.extractor.input.Data;
import org.eclipse.scada.base.extractor.mqtt.input.MqttData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MqttInput
extends AbstractInput {
    private static final Logger logger = LoggerFactory.getLogger(MqttInput.class);
    private final String serverUri;
    private final String clientId;
    private MqttAsyncClient client;
    private final ScheduledExecutorService executor;
    private boolean started;
    private final String topic;
    private final int qos;
    private final long reconnectDelay = 10000L;
    private final MqttCallback callback = new MqttCallback(){

        public void messageArrived(String topic, MqttMessage msg) throws Exception {
            MqttInput.this.handleMessage(topic, msg);
        }

        public void deliveryComplete(IMqttDeliveryToken token) {
        }

        public void connectionLost(Throwable e) {
            MqttInput.this.handleDisconnected(e);
        }
    };

    public MqttInput(ScheduledExecutorService executor, String serverUri, String clientId, String topic, int qos) {
        super((Executor)executor);
        this.executor = executor;
        this.serverUri = serverUri;
        this.clientId = this.makeClientId(clientId);
        this.topic = topic;
        this.qos = qos;
    }

    protected void handleMessage(String topic, MqttMessage msg) {
        logger.debug("Got message - topic: {}, message: {}", (Object)topic, (Object)msg);
        this.fireData(new MqttData(msg));
    }

    private String makeClientId(String clientId) {
        if (clientId != null) {
            return clientId;
        }
        return MqttAsyncClient.generateClientId();
    }

    public synchronized void start() {
        logger.info("Request to start component: {}", (Object)this);
        if (this.started) {
            logger.debug("Component already started");
            return;
        }
        this.started = true;
        this.triggerConnect();
    }

    public synchronized void stop() {
        logger.info("Request to stop component: {}", (Object)this);
        if (!this.started) {
            logger.debug("Component already stopped");
            return;
        }
        this.started = false;
        if (this.client != null) {
            try {
                try {
                    logger.debug("Disconnecting client");
                    this.client.disconnect().waitForCompletion();
                }
                catch (MqttException e) {
                    logger.warn("Failed to close MQTT Client", (Throwable)e);
                    this.client = null;
                    this.fireDisposed();
                }
            }
            finally {
                this.client = null;
                this.fireDisposed();
            }
        }
    }

    protected synchronized void triggerConnect() {
        if (!this.started) {
            return;
        }
        try {
            this.client = new MqttAsyncClient(this.serverUri, this.clientId, (MqttClientPersistence)new MemoryPersistence(), (MqttPingSender)new TimerPingSender());
            this.client.setCallback(this.callback);
            this.client.connect(null, new IMqttActionListener(){

                public void onSuccess(IMqttToken token) {
                    MqttInput.this.handleConnected();
                }

                public void onFailure(IMqttToken token, Throwable e) {
                    MqttInput.this.handleDisconnected(e);
                }
            });
        }
        catch (MqttException e) {
            this.handleDisconnected(e);
        }
    }

    protected synchronized void handleDisconnected(Throwable e) {
        logger.info("Disconnected from: {}", (Object)this.serverUri);
        if (e != null) {
            logger.info("Disconnect reason", e);
        }
        try {
            if (this.client != null) {
                this.client.close();
            }
        }
        catch (Exception e2) {
            logger.warn("Failed to close", (Throwable)e2);
        }
        this.client = null;
        this.fireData(new Data(null, e));
        if (this.started) {
            this.executor.schedule(new Runnable(){

                @Override
                public void run() {
                    MqttInput.this.triggerConnect();
                }
            }, 10000L, TimeUnit.MILLISECONDS);
        }
    }

    protected synchronized void handleConnected() {
        logger.info("Connected to: {}", (Object)this.serverUri);
        try {
            logger.debug("Subscribe to: {} (qos: {})", (Object)this.topic, (Object)this.qos);
            IMqttToken token = this.client.subscribe(this.topic, this.qos);
            token.setActionCallback(new IMqttActionListener(){

                public void onSuccess(IMqttToken token) {
                    logger.debug("Subscription OK: {}/{}", (Object)MqttInput.this.serverUri, (Object)MqttInput.this.topic);
                }

                public void onFailure(IMqttToken token, Throwable e) {
                    logger.info("Subscription failed: {}/{}", (Object)MqttInput.this.serverUri, (Object)MqttInput.this.topic);
                    logger.info("Subscription error", e);
                }
            });
        }
        catch (MqttException e) {
            this.handleDisconnected(e);
        }
    }

    public String toString() {
        return String.format("[MqttInput - serverUri: %s, topic: %s, qos: %s]", this.serverUri, this.topic, this.qos);
    }
}

