/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.setup.common;

import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.emf.validation.model.ConstraintStatus;
import org.eclipse.scada.configuration.lib.Properties;
import org.eclipse.scada.configuration.setup.common.Postgres;
import org.eclipse.scada.configuration.setup.common.PostgresSetupModule;
import org.eclipse.scada.configuration.world.setup.OperatingSystemDescriptor;

public class PostgresValidator
extends Postgres {
    private final OperatingSystemDescriptor os;
    private final IValidationContext ctx;

    public PostgresValidator(PostgresSetupModule postgres, OperatingSystemDescriptor os, IValidationContext ctx) {
        super(postgres);
        this.os = os;
        this.ctx = ctx;
    }

    protected IStatus createFailure(String message, Object ... arguments) {
        return ConstraintStatus.createStatus((IValidationContext)this.ctx, null, null, (String)message, (Object[])arguments);
    }

    public IStatus validate() {
        LinkedList<IStatus> result = new LinkedList<IStatus>();
        this.performValidation(result);
        if (result.isEmpty()) {
            return Status.OK_STATUS;
        }
        return ConstraintStatus.createMultiStatus((IValidationContext)this.ctx, result);
    }

    protected void performValidation(Collection<IStatus> result) {
        String version = Properties.get((Collection)this.os.getProperties(), (String)"postgresql.version", null);
        if (version == null) {
            result.add(this.createFailure("Operating system does not provide PostgreSQL", new Object[0]));
        } else if (!"9.3".equals(version)) {
            result.add(this.createFailure("Requires '{0}' = {1} but found ({2})", "postgresql.version", "9.3", version));
        }
        Map props = Properties.makeAttributes((Collection)this.os.getProperties());
        this.getConfigurationFile(props);
        this.getHostBasedAccessFile(props);
    }
}

