/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.hd.ui.views;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.scada.hd.QueryListener;
import org.eclipse.scada.hd.QueryState;
import org.eclipse.scada.hd.data.QueryParameters;
import org.eclipse.scada.hd.data.ValueInformation;
import org.eclipse.scada.hd.ui.views.Messages;
import org.eclipse.scada.hd.ui.views.QueryViewPart;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class QueryDataView
extends QueryViewPart
implements QueryListener {
    private static final int FIX_FRONT_COLS = 3;
    private final Map<String, TableColumn> columns = new HashMap<String, TableColumn>();
    private TableColumn indexCol;
    private Table table;
    private Color invalidColor;
    private String[] colNames;
    private TableColumn qualityCol;
    private TableColumn manualCol;
    private TableColumn infoCol;
    private TableColumn countCol;

    public void createPartControl(Composite parent) {
        this.addListener();
        parent.setLayout((Layout)new FillLayout());
        this.table = new Table(parent, 65536);
        this.table.setHeaderVisible(true);
        this.indexCol = new TableColumn(this.table, 0);
        this.indexCol.setText(Messages.QueryDataView_ColIndex);
        this.indexCol.setWidth(50);
        this.qualityCol = new TableColumn(this.table, 0);
        this.qualityCol.setText(Messages.QueryDataView_ColQuality);
        this.qualityCol.setWidth(75);
        this.manualCol = new TableColumn(this.table, 0);
        this.manualCol.setText(Messages.QueryDataView_ColManual);
        this.manualCol.setWidth(75);
        this.invalidColor = JFaceColors.getErrorBackground((Display)this.getDisplay());
    }

    public void setFocus() {
        this.table.setFocus();
    }

    @Override
    protected void clear() {
        this.clearDataSize();
        super.clear();
    }

    public void updateData(final int index, final Map<String, List<Double>> values, final List<ValueInformation> valueInformation) {
        this.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                QueryDataView.this.handleUpdateData(index, values, valueInformation);
            }
        });
    }

    private void handleUpdateData(int index, Map<String, List<Double>> values, List<ValueInformation> valueInformation) {
        int len = valueInformation.size();
        int i = 0;
        while (i < len) {
            TableItem item = this.table.getItem(i + index);
            double quality = valueInformation.get(i).getQuality();
            double manual = valueInformation.get(i).getManualPercentage();
            item.setText(0, String.format(Messages.QueryDataView_Format_Index, index + i));
            item.setText(1, String.format(Messages.QueryDataView_Format_Quality, quality));
            item.setText(2, String.format(Messages.QueryDataView_Format_Manual, manual));
            int j = 0;
            while (j < this.colNames.length) {
                List<Double> value = values.get(this.colNames[j]);
                item.setText(j + 3, this.getValueString(value.get(i)));
                ++j;
            }
            item.setText(this.colNames.length + 3, "" + valueInformation.get(i).getSourceValues());
            item.setText(this.colNames.length + 3 + 1, String.format(Messages.QueryDataView_InfoFormat, valueInformation.get(i).getStartTimestamp(), valueInformation.get(i).getEndTimestamp()));
            if (quality < 0.33) {
                item.setBackground(this.invalidColor);
            } else {
                item.setBackground(null);
            }
            ++i;
        }
    }

    private String getValueString(Double value) {
        if (value.isInfinite()) {
            return Messages.QueryDataView_Infinity;
        }
        if (value.isNaN()) {
            return Messages.QueryDataView_NaN;
        }
        return String.format(Messages.QueryDataView_Format_Value, value);
    }

    protected Display getDisplay() {
        try {
            return this.getSite().getShell().getDisplay();
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public void updateParameters(final QueryParameters parameters, final Set<String> valueTypes) {
        this.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                QueryDataView.this.setDataSize(parameters.getNumberOfEntries(), valueTypes);
            }
        });
    }

    private void setDataSize(int entries, Set<String> valueTypes) {
        this.clearDataSize();
        this.colNames = valueTypes.toArray(new String[0]);
        for (String valueType : valueTypes) {
            TableColumn col = new TableColumn(this.table, 0);
            col.setText(valueType);
            col.setWidth(100);
            col.setAlignment(131072);
            this.columns.put(valueType, col);
        }
        this.countCol = new TableColumn(this.table, 0);
        this.countCol.setText(Messages.QueryDataView_ColValues);
        this.countCol.setWidth(40);
        this.infoCol = new TableColumn(this.table, 0);
        this.infoCol.setText(Messages.QueryDataView_ColInfo);
        this.infoCol.setWidth(150);
        this.table.clearAll();
        this.table.setItemCount(entries);
        int i = 0;
        while (i < entries) {
            TableItem item = this.table.getItem(i);
            item.setBackground(this.invalidColor);
            item.setText(0, String.format(Messages.QueryDataView_Format_Index, i));
            ++i;
        }
    }

    private void clearDataSize() {
        this.table.clearAll();
        for (TableColumn col : this.columns.values()) {
            col.dispose();
        }
        this.columns.clear();
        if (this.countCol != null) {
            this.countCol.dispose();
            this.countCol = null;
        }
        if (this.infoCol != null) {
            this.infoCol.dispose();
            this.infoCol = null;
        }
    }

    public void updateState(QueryState state) {
    }
}

