/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.utils.osgi.jdbc.task;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.scada.utils.osgi.jdbc.data.RowMapper;
import org.eclipse.scada.utils.osgi.jdbc.data.RowMapperException;
import org.eclipse.scada.utils.osgi.jdbc.data.SingleColumnRowMapper;
import org.eclipse.scada.utils.osgi.jdbc.task.ConnectionContext;
import org.eclipse.scada.utils.osgi.jdbc.task.ResultSetProcessor;
import org.eclipse.scada.utils.osgi.jdbc.task.RowCallback;
import org.eclipse.scada.utils.sql.SqlHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CommonConnectionContext
implements ConnectionContext {
    private static final Logger logger = LoggerFactory.getLogger(CommonConnectionContext.class);

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.getConnection().setAutoCommit(autoCommit);
    }

    @Override
    public void commit() throws SQLException {
        this.getConnection().commit();
    }

    @Override
    public void rollback() throws SQLException {
        this.getConnection().rollback();
    }

    @Override
    public <T> List<T> queryForList(Class<T> clazz, String sql, Object ... parameters) throws SQLException {
        return this.query(new SingleColumnRowMapper<T>(clazz), sql, parameters);
    }

    @Override
    public <T> List<T> queryForList(Class<T> clazz, String sql, Map<String, Object> parameters) throws SQLException {
        return this.query(new SingleColumnRowMapper<T>(clazz), sql, parameters);
    }

    @Override
    public <T> List<T> query(RowMapper<T> rowMapper, String sql, Object ... parameters) throws SQLException {
        CaptureMappedResultSetProcessor<T> crsp = new CaptureMappedResultSetProcessor<T>(rowMapper);
        this.query(crsp, sql, parameters);
        return crsp.getResult();
    }

    @Override
    public <T> List<T> query(RowMapper<T> rowMapper, String sql, Map<String, Object> parameters) throws SQLException {
        CaptureMappedResultSetProcessor<T> crsp = new CaptureMappedResultSetProcessor<T>(rowMapper);
        this.query(crsp, sql, parameters);
        return crsp.getResult();
    }

    @Override
    public void query(final RowCallback callback, String sql, Object ... parameters) throws SQLException {
        this.query(new ResultSetProcessor(){

            @Override
            public void processResult(ResultSet resultSet) throws SQLException {
                while (resultSet.next()) {
                    callback.processRow(resultSet);
                }
            }
        }, sql, parameters);
    }

    @Override
    public void query(final RowCallback callback, String sql, Map<String, Object> parameters) throws SQLException {
        this.query(new ResultSetProcessor(){

            @Override
            public void processResult(ResultSet resultSet) throws SQLException {
                while (resultSet.next()) {
                    callback.processRow(resultSet);
                }
            }
        }, sql, parameters);
    }

    @Override
    public void query(ResultSetProcessor resultSetProcessor, String sql, Map<String, Object> parameters) throws SQLException {
        logger.trace("Preparing query SQL - {}", (Object)sql);
        HashMap posMap = new HashMap();
        String convertedSql = SqlHelper.convertSql((String)sql, posMap);
        logger.trace("Converted sql from '{}' to '{}' for positional parameters", (Object)sql, (Object)convertedSql);
        this.query(resultSetProcessor, convertedSql, SqlHelper.expandParameters(posMap, parameters));
    }

    @Override
    public void query(ResultSetProcessor resultSetProcessor, String sql, Object ... parameters) throws SQLException {
        logger.trace("Preparing query SQL - {}", (Object)sql);
        try (PreparedStatement stmt = this.getConnection().prepareStatement(sql);){
            this.applyParameters(stmt, parameters);
            try (ResultSet rs = stmt.executeQuery();){
                resultSetProcessor.processResult(rs);
            }
        }
    }

    @Override
    public <T> T queryForObject(RowMapper<T> rowMapper, String sql, Map<String, Object> parameters) throws SQLException {
        CaptureMappedResultSetProcessor<T> crsp = new CaptureMappedResultSetProcessor<T>(rowMapper);
        this.query(crsp, sql, parameters);
        if (crsp.getResult().size() == 0) {
            return null;
        }
        if (crsp.getResult().size() > 1) {
            throw new SQLException("too many results");
        }
        return crsp.getResult().get(0);
    }

    @Override
    public <T> T queryForObject(RowMapper<T> rowMapper, String sql, Object ... parameters) throws SQLException {
        CaptureMappedResultSetProcessor<T> crsp = new CaptureMappedResultSetProcessor<T>(rowMapper);
        this.query(crsp, sql, parameters);
        if (crsp.getResult().size() == 0) {
            return null;
        }
        if (crsp.getResult().size() > 1) {
            throw new SQLException("too many results");
        }
        return crsp.getResult().get(0);
    }

    protected void applyParameters(PreparedStatement stmt, Object ... parameters) throws SQLException {
        if (parameters != null) {
            int i = 0;
            while (i < parameters.length) {
                logger.trace("Set parameter #{} - {}", (Object)(i + 1), parameters[i]);
                stmt.setObject(i + 1, parameters[i]);
                ++i;
            }
        }
    }

    @Override
    public int update(String sql, Object ... parameters) throws SQLException {
        logger.trace("Preparing update SQL - {}", (Object)sql);
        try (PreparedStatement stmt = this.getConnection().prepareStatement(sql);){
            this.applyParameters(stmt, parameters);
            int n = stmt.executeUpdate();
            return n;
        }
    }

    @Override
    public int update(String sql, Map<String, Object> parameters) throws SQLException {
        HashMap posMap = new HashMap();
        return this.update(SqlHelper.convertSql((String)sql, posMap), SqlHelper.expandParameters(posMap, parameters));
    }

    private static class CaptureMappedResultSetProcessor<T>
    implements ResultSetProcessor {
        private List<T> result;
        private final RowMapper<T> mapper;

        public CaptureMappedResultSetProcessor(RowMapper<T> mapper) {
            this.mapper = mapper;
        }

        @Override
        public void processResult(ResultSet resultSet) throws SQLException, RowMapperException {
            this.result = new ArrayList<T>();
            this.mapper.validate(resultSet);
            while (resultSet.next()) {
                T mapped = this.mapper.mapRow(resultSet);
                if (mapped == null) continue;
                this.result.add(mapped);
            }
        }

        public List<T> getResult() {
            return this.result;
        }
    }
}

