/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.base.extractor.extract.pattern;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import org.eclipse.scada.base.extractor.extract.ItemValue;
import org.eclipse.scada.base.extractor.extract.pattern.FieldSpec;
import org.eclipse.scada.core.Variant;

public class ValueFieldDescriptor {
    private final FieldSpec primaryValue;
    private final Map<String, FieldSpec> attributes;

    public ValueFieldDescriptor(FieldSpec primaryValue, Map<String, FieldSpec> attributes) {
        this.primaryValue = primaryValue;
        this.attributes = attributes == null ? Collections.emptyMap() : attributes;
    }

    public FieldSpec getPrimaryValue() {
        return this.primaryValue;
    }

    public Map<String, FieldSpec> getAttributes() {
        return this.attributes;
    }

    public ItemValue buildValue(Matcher m) throws Exception {
        Variant value = this.primaryValue.extractValue(m);
        HashMap<String, Variant> attributes = new HashMap<String, Variant>(this.attributes.size());
        for (Map.Entry<String, FieldSpec> entry : this.attributes.entrySet()) {
            attributes.put(entry.getKey(), entry.getValue().extractValue(m));
        }
        return new ItemValue(value, attributes);
    }
}

