/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.base.extractor.input;

import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import org.eclipse.scada.base.extractor.input.Data;
import org.eclipse.scada.base.extractor.input.Input;
import org.eclipse.scada.base.extractor.input.InputDisposed;
import org.eclipse.scada.base.extractor.transform.Transformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractInput
implements Input {
    private static final Logger logger = LoggerFactory.getLogger(AbstractInput.class);
    private final Set<Input.Listener> listeners = new HashSet<Input.Listener>();
    private final Executor executor;
    private Data lastData;
    private final List<Transformer> transformers = new LinkedList<Transformer>();

    public AbstractInput(Executor executor) {
        this.executor = executor;
    }

    @Override
    public synchronized void addTransformer(Transformer transformer) {
        this.transformers.add(transformer);
    }

    @Override
    public synchronized void removeTransformer(Transformer transformer) {
        this.transformers.remove(transformer);
    }

    @Override
    public synchronized void setTransformers(Transformer[] transformers) {
        this.transformers.clear();
        this.transformers.addAll(Arrays.asList(transformers));
    }

    @Override
    public synchronized void addInputListener(final Input.Listener listener) {
        if (this.listeners.add(listener) && this.lastData != null) {
            final Data data = this.lastData;
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    AbstractInput.this.processFireData(new Input.Listener[]{listener}, data);
                }
            });
        }
    }

    @Override
    public synchronized void removeInputListener(Input.Listener listener) {
        this.listeners.remove(listener);
    }

    protected synchronized void fireDisposed() {
        this.fireData(new Data(null, new InputDisposed()));
    }

    protected synchronized void fireData(Data data) {
        final Data transformedData = this.transform(data);
        final Input.Listener[] listeners = this.listeners.toArray(new Input.Listener[this.listeners.size()]);
        this.lastData = data;
        try {
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    AbstractInput.this.processFireData(listeners, transformedData);
                }
            });
        }
        catch (Exception e) {
            logger.warn("Failed to fireData", (Throwable)e);
        }
    }

    protected Data transform(Data data) {
        if (this.transformers.isEmpty()) {
            return data;
        }
        for (Transformer t : this.transformers) {
            try {
                data = t.transform(data);
            }
            catch (Exception e) {
                data = new Data(null, e);
            }
        }
        return data;
    }

    protected void processFireData(Input.Listener[] listeners, Data data) {
        Input.Listener[] listenerArray = listeners;
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            Input.Listener l = listenerArray[n2];
            try {
                l.processInput(data);
            }
            catch (Exception e) {
                logger.warn("Failed to process listener", (Throwable)e);
            }
            ++n2;
        }
    }

    @Override
    public synchronized void dispose() {
        this.stop();
        this.listeners.clear();
    }
}

