/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.utils;

import java.io.IOException;
import javax.inject.Inject;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.scada.configuration.recipe.lib.Output;
import org.eclipse.scada.configuration.utils.ModelLoader;
import org.eclipse.scada.utils.inject.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadModel {
    private static final Logger logger = LoggerFactory.getLogger(LoadModel.class);
    @Output
    private Object model;
    @Inject
    @Optional
    private Class<?> modelClazz;
    @Inject
    @Optional
    private String documentRoot;
    @Inject
    private String uri;

    public void load() throws IOException {
        logger.debug("Loading model - documentRoot: {}, modelClazz: {}", new Object[]{this.documentRoot, this.uri, this.modelClazz});
        URI uri = URI.createURI((String)this.uri);
        if (this.documentRoot != null) {
            URI base = URI.createURI((String)this.documentRoot);
            uri = uri.resolve(base);
            logger.debug("Resolved URI: {}", (Object)uri);
        }
        ModelLoader<EObject> loader = new ModelLoader<EObject>(this.modelClazz == null ? EObject.class : this.modelClazz);
        this.model = loader.load(uri);
    }

    public Object getModel() {
        return this.model;
    }
}

