/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.utils;

import java.io.IOException;
import javax.inject.Inject;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.scada.configuration.utils.ModelWriter;
import org.eclipse.scada.utils.inject.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoreModel {
    private static final Logger logger = LoggerFactory.getLogger(StoreModel.class);
    @Inject
    private EObject model;
    @Inject
    @Optional
    private String documentRoot;
    @Inject
    @Optional
    private IContainer output;
    @Inject
    private String uri;
    @Inject
    @Optional
    private IProgressMonitor monitor;

    public void store() throws IOException, CoreException {
        URI base;
        logger.debug("Store model - documentRoot: {}, uri: {}", (Object)this.documentRoot, (Object)this.uri);
        URI uri = URI.createURI((String)this.uri);
        if (this.output != null) {
            base = URI.createURI((String)(String.valueOf(this.output.getLocationURI().toString()) + "/"));
            uri = uri.resolve(base);
            logger.debug("Resolved URI: {} using container ({})", (Object)uri, (Object)this.output.getLocationURI());
        } else if (this.documentRoot != null) {
            base = URI.createURI((String)this.documentRoot);
            uri = uri.resolve(base);
            logger.debug("Resolved URI: {}", (Object)uri);
        }
        ModelWriter writer = new ModelWriter(this.model);
        writer.store(uri);
        if (this.output != null) {
            this.output.refreshLocal(1, (IProgressMonitor)(this.monitor != null ? this.monitor : new NullProgressMonitor()));
        }
    }
}

