/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.world.lib.deployment;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.Collection;
import java.util.Map;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.scada.configuration.world.ApplicationNode;
import org.eclipse.scada.configuration.world.deployment.CommonDeploymentMechanism;
import org.eclipse.scada.configuration.world.deployment.StartupMechanism;
import org.eclipse.scada.configuration.world.lib.deployment.CommonHandler;
import org.eclipse.scada.configuration.world.lib.deployment.Contents;
import org.eclipse.scada.configuration.world.lib.deployment.DeploymentContext;
import org.eclipse.scada.configuration.world.lib.deployment.FileInformation;
import org.eclipse.scada.configuration.world.lib.deployment.FileOptions;
import org.eclipse.scada.configuration.world.lib.deployment.OperatingSystemDescriptors;
import org.eclipse.scada.configuration.world.lib.deployment.ScoopFilesVisitor;
import org.eclipse.scada.configuration.world.lib.deployment.startup.LSBSystemVHandler;
import org.eclipse.scada.configuration.world.lib.deployment.startup.RedhatSystemVHandler;
import org.eclipse.scada.configuration.world.lib.deployment.startup.StartupHandler;
import org.eclipse.scada.configuration.world.lib.deployment.startup.UpstartHandler;
import org.eclipse.scada.configuration.world.lib.setup.SubModuleHandler;
import org.eclipse.scada.configuration.world.osgi.profile.Profile;
import org.eclipse.scada.configuration.world.osgi.profile.ProfileFactory;
import org.eclipse.scada.configuration.world.osgi.profile.ProfilePackage;
import org.eclipse.scada.configuration.world.osgi.profile.SystemProperty;
import org.eclipse.scada.configuration.world.setup.SetupModule;
import org.eclipse.scada.utils.pkg.deb.ContentProvider;
import org.eclipse.scada.utils.pkg.deb.FileContentProvider;
import org.eclipse.scada.utils.pkg.deb.StaticContentProvider;
import org.eclipse.scada.utils.str.StringHelper;

public abstract class CommonPackageHandler
extends CommonHandler {
    private final CommonDeploymentMechanism deploy;
    private StartupHandler startupHandler;
    private DeploymentContext deploymentContext;

    public CommonPackageHandler(ApplicationNode applicationNode, CommonDeploymentMechanism deploy) {
        super(applicationNode);
        this.deploy = deploy;
    }

    @Override
    protected void handleProcess(IFolder nodeDir, IProgressMonitor monitor, Map<String, String> properties) throws Exception {
        if (this.deploymentContext != null) {
            this.runSetup(this.deploy, this.deploymentContext, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            if (!this.makeEquinoxList().isEmpty()) {
                String data = String.valueOf(StringHelper.join(this.makeEquinoxList(), (String)"\n")) + "\n";
                this.deploymentContext.addFile((ContentProvider)new StaticContentProvider(data), "/etc/eclipsescada/applications", new FileInformation(420, null, null, FileOptions.CONFIGURATION));
            }
        }
    }

    protected void setDeploymentContext(DeploymentContext deploymentContext) {
        this.deploymentContext = deploymentContext;
    }

    protected void createDrivers(IFolder nodeDir, IProgressMonitor monitor, File packageFolder, Map<String, String> replacements) throws IOException, Exception {
        for (String driverName : this.makeDriverList()) {
            this.createDriver(nodeDir, monitor, packageFolder, replacements, driverName);
        }
    }

    protected void createDriver(IFolder nodeDir, IProgressMonitor monitor, File packageFolder, Map<String, String> replacements, String driverName) throws IOException, Exception {
        File sourceDir = new File(nodeDir.getLocation().toFile(), driverName);
        replacements.put("driverName", driverName);
        this.processDriver(monitor, packageFolder, replacements, driverName, sourceDir);
        replacements.remove("driverName");
    }

    protected void processDriver(IProgressMonitor monitor, File packageFolder, Map<String, String> replacements, String driverName, File sourceDir) throws IOException, Exception {
        Path sourcePath = sourceDir.toPath().toAbsolutePath();
        String driverDir = "/etc/eclipsescada/drivers/" + driverName;
        Files.walkFileTree(sourceDir.toPath(), new ScoopFilesVisitor(sourcePath, this.deploymentContext, driverDir));
        this.deploymentContext.addDirectory(driverDir, new FileInformation(493));
        this.deploymentContext.addFile(Contents.createContent(CommonPackageHandler.class.getResourceAsStream("templates/driver.logback.xml"), replacements), String.valueOf(driverDir) + "/logback.xml", new FileInformation(420, null, null, FileOptions.CONFIGURATION));
        this.deploymentContext.addFile(Contents.createContent(CommonPackageHandler.class.getResourceAsStream("templates/jvm.args"), replacements), String.valueOf(driverDir) + "/jvm.args", new FileInformation(420, null, null, FileOptions.CONFIGURATION));
        StartupHandler sm = this.createStartupHandler(this.getDefaultStartupMechanism());
        if (sm != null) {
            sm.createDriver(this.deploymentContext, driverName, replacements, monitor);
        }
    }

    protected void createEquinox(File sourceBase, File packageFolder, Map<String, String> replacements, IProgressMonitor monitor) throws Exception {
        for (String name : this.makeEquinoxList()) {
            replacements.put("appName", name);
            this.processEquinox(sourceBase, packageFolder, replacements, monitor, name);
            replacements.remove("appName");
        }
    }

    protected void processEquinox(File sourceBase, File packageFolder, Map<String, String> replacements, IProgressMonitor monitor, String name) throws IOException, Exception, FileNotFoundException {
        File source = new File(sourceBase, String.valueOf(name) + "/" + name + ".profile.xml");
        File tempFile = File.createTempFile("profile", ".xml");
        try {
            Files.copy(source.toPath(), tempFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            this.patchProfile(name, tempFile);
            this.deploymentContext.addFile((ContentProvider)new FileContentProvider(tempFile), "/usr/share/eclipsescada/profiles/" + name + ".profile.xml", new FileInformation(416, "root", "eclipsescada", new FileOptions[0]));
        }
        finally {
            tempFile.delete();
        }
        this.deploymentContext.addDirectory("/usr/share/eclipsescada/profiles/" + name, new FileInformation(493));
        this.deploymentContext.addFile(Contents.createContent(CommonPackageHandler.class.getResourceAsStream("templates/app.logback.xml"), replacements), "/usr/share/eclipsescada/profiles/" + name + "/logback.xml", null);
        this.deploymentContext.addFile(Contents.createContent(CommonPackageHandler.class.getResourceAsStream("templates/scada.createApplication"), replacements), "/usr/bin/scada.create." + name, new FileInformation(493));
        this.deploymentContext.addFile((ContentProvider)new FileContentProvider(new File(sourceBase, String.valueOf(name) + "/data.json")), "/usr/share/eclipsescada/ca.bootstrap/bootstrap." + name + ".json", new FileInformation(416, "root", "eclipsescada", new FileOptions[0]));
        StartupHandler sm = this.createStartupHandler(this.getDefaultStartupMechanism());
        if (sm != null) {
            sm.createEquinox(this.deploymentContext, name, replacements, monitor);
        }
    }

    protected void patchProfile(String appName, File file) throws IOException {
        ResourceSetImpl rs = new ResourceSetImpl();
        Resource r = rs.createResource(URI.createFileURI((String)file.toString()));
        r.load(null);
        Profile profile = (Profile)EcoreUtil.getObjectByType((Collection)r.getContents(), (EClassifier)ProfilePackage.Literals.PROFILE);
        SystemProperty bootstrap = ProfileFactory.eINSTANCE.createSystemProperty();
        bootstrap.setKey("org.eclipse.scada.ca.file.provisionJsonUrl");
        bootstrap.setValue("file:///usr/share/eclipsescada/ca.bootstrap/bootstrap." + appName + ".json");
        profile.getProperty().add((Object)bootstrap);
        r.save(null);
    }

    protected abstract StartupMechanism getDefaultStartupMechanism();

    protected StartupHandler getStartupHandler() {
        if (this.startupHandler == null) {
            this.startupHandler = this.createStartupHandler();
        }
        return this.startupHandler;
    }

    private StartupHandler createStartupHandler() {
        return this.createStartupHandler(this.getDefaultStartupMechanism());
    }

    private StartupHandler createStartupHandler(StartupMechanism defaultStartupMechanism) {
        StartupMechanism sm = this.getStartupMechanism(defaultStartupMechanism);
        if (sm == null) {
            return null;
        }
        switch (sm) {
            case REDHAT_SYSV: {
                return new RedhatSystemVHandler();
            }
            case UPSTART: {
                return new UpstartHandler(this.deploy.getOperatingSystem());
            }
            case LSB_SYSV: {
                return new LSBSystemVHandler();
            }
            case DEFAULT: {
                return null;
            }
        }
        throw new IllegalStateException(String.format("Startup method %s is unsupported", sm));
    }

    private StartupMechanism getStartupMechanism(StartupMechanism defaultStartupMechanism) {
        if (this.deploy.getStartupMechanism() == null || this.deploy.getStartupMechanism() == StartupMechanism.DEFAULT) {
            String type = OperatingSystemDescriptors.getProperty(this.deploy.getOperatingSystem(), "startup", defaultStartupMechanism.name());
            return StartupMechanism.valueOf((String)type);
        }
        return this.deploy.getStartupMechanism();
    }

    protected String makeCreate(CommonDeploymentMechanism deploy) {
        StringBuilder sb = new StringBuilder();
        if (deploy.isAutomaticCreate()) {
            String flags = deploy.getRecreateBackups() == null ? "-i" : (deploy.getRecreateBackups() > 0 ? "-b " + deploy.getRecreateBackups() : "-d");
            for (String app : this.makeEquinoxList()) {
                sb.append(String.format("echo -n Creating application \\'%s\\' ...\n", app));
                sb.append(String.format("scada.create.%s %s > /dev/null\n", app, flags));
                sb.append(String.format("echo \" done!\"\n", app));
            }
        }
        return sb.toString();
    }

    protected void runSetup(CommonDeploymentMechanism deploy, DeploymentContext context, IProgressMonitor monitor) throws Exception {
        if (deploy.getSetup() != null) {
            SubModuleHandler.runSetup(context, (Collection<? extends SetupModule>)deploy.getSetup().getModules(), this.deploy.getOperatingSystem());
        }
        SubModuleHandler.runSetup(context, (Collection<? extends SetupModule>)deploy.getAdditionalSetupModules(), deploy.getOperatingSystem());
        monitor.done();
    }
}

