/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.world.lib.deployment.debian;

import com.google.common.io.CharStreams;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.scada.configuration.lib.Nodes;
import org.eclipse.scada.configuration.world.ApplicationNode;
import org.eclipse.scada.configuration.world.Node;
import org.eclipse.scada.configuration.world.deployment.ChangeEntry;
import org.eclipse.scada.configuration.world.deployment.CommonDeploymentMechanism;
import org.eclipse.scada.configuration.world.deployment.DebianDeploymentMechanism;
import org.eclipse.scada.configuration.world.deployment.StartupMechanism;
import org.eclipse.scada.configuration.world.lib.deployment.ChangeEntryComparator;
import org.eclipse.scada.configuration.world.lib.deployment.CommonHandler;
import org.eclipse.scada.configuration.world.lib.deployment.CommonPackageHandler;
import org.eclipse.scada.configuration.world.lib.deployment.Contents;
import org.eclipse.scada.configuration.world.lib.deployment.ScoopFilesVisitor;
import org.eclipse.scada.configuration.world.lib.deployment.debian.DebianDeploymentContext;
import org.eclipse.scada.configuration.world.lib.deployment.startup.StartupHandler;
import org.eclipse.scada.utils.pkg.deb.DebianPackageWriter;
import org.eclipse.scada.utils.pkg.deb.control.BinaryPackageControlFile;
import org.eclipse.scada.utils.pkg.deb.control.GenericControlFile;
import org.eclipse.scada.utils.str.StringHelper;

public class DebianHandler
extends CommonPackageHandler {
    private static final String CONTROL_SCRIPTS_DIR = "/usr/lib/eclipsescada/packagescripts";
    private final DebianDeploymentMechanism deploy;

    public DebianHandler(ApplicationNode applicationNode, DebianDeploymentMechanism deploy) {
        super(applicationNode, (CommonDeploymentMechanism)deploy);
        this.deploy = deploy;
    }

    @Override
    protected String getBaseFolderName() {
        return "debian-packages";
    }

    @Override
    protected void handleProcess(IFolder nodeDir, IProgressMonitor monitor, Map<String, String> properties) throws Exception {
        File packageFolder = this.getPackageFolder(nodeDir);
        String packageName = this.getPackageName();
        DebianDeploymentContext context = new DebianDeploymentContext(packageName);
        this.setDeploymentContext(context);
        super.handleProcess(nodeDir, monitor, properties);
        String version = this.findVersion();
        BinaryPackageControlFile packageControlFile = new BinaryPackageControlFile();
        packageControlFile.setPackage(packageName);
        packageControlFile.setArchitecture("all");
        packageControlFile.setVersion(version);
        packageControlFile.setPriority("required");
        packageControlFile.setSection("misc");
        packageControlFile.setMaintainer(String.format("%s <%s>", this.deploy.getMaintainer().getName(), this.deploy.getMaintainer().getEmail()));
        packageControlFile.setDescription(String.format("Configuration package for %s", Nodes.makeName((Node)this.applicationNode)), "This is an automatically generated configuration package");
        packageControlFile.set(BinaryPackageControlFile.Fields.CONFLICTS, "org.openscada.drivers.common, org.openscada");
        HashMap<String, String> replacements = new HashMap<String, String>();
        replacements.put("packageName", packageName);
        replacements.put("authorName", this.deploy.getMaintainer().getName());
        replacements.put("authorEmail", this.deploy.getMaintainer().getEmail());
        replacements.put("nodeName", this.applicationNode.getName() == null ? this.applicationNode.getHostName() : this.applicationNode.getName());
        replacements.put("stop.apps", this.createStopApps());
        replacements.put("start.apps", this.createStartApps());
        replacements.put("create.apps", this.makeCreate((CommonDeploymentMechanism)this.deploy));
        replacements.put("multiuserScreen", this.deploy.isMultiUserScreen() ? "1" : "0");
        this.createDrivers(nodeDir, monitor, packageFolder, replacements);
        this.createEquinox(nodeDir.getLocation().toFile(), packageFolder, replacements, monitor);
        try {
            Path src = new File(packageFolder, "src").toPath();
            if (src.toFile().isDirectory()) {
                ScoopFilesVisitor scoop = new ScoopFilesVisitor(src, context, null);
                scoop.getIgnorePrefix().add(CONTROL_SCRIPTS_DIR);
                Files.walkFileTree(src, scoop);
            }
            packageControlFile.set(BinaryPackageControlFile.Fields.DEPENDS, this.makeDependencies(context.getDependencies()));
            File outputFile = new File(nodeDir.getLocation().toFile(), packageControlFile.makeFileName());
            outputFile.getParentFile().mkdirs();
            Throwable throwable = null;
            Object var13_14 = null;
            try (DebianPackageWriter deb = new DebianPackageWriter((OutputStream)new FileOutputStream(outputFile), (GenericControlFile)packageControlFile);){
                replacements.put("postinst.scripts", String.valueOf(context.getPostInstallationString()) + "\n" + this.createUserScriptCallbacks(packageFolder, "postinst"));
                replacements.put("preinst.scripts", String.valueOf(context.getPreInstallationString()) + "\n" + this.createUserScriptCallbacks(packageFolder, "preinst"));
                replacements.put("prerm.scripts", String.valueOf(context.getPreRemovalString()) + "\n" + this.createUserScriptCallbacks(packageFolder, "prerm"));
                replacements.put("postrm.scripts", String.valueOf(context.getPostRemovalString()) + "\n" + this.createUserScriptCallbacks(packageFolder, "postrm"));
                deb.setPostinstScript(Contents.createContent(CommonHandler.class.getResourceAsStream("templates/deb/postinst"), replacements));
                deb.setPostrmScript(Contents.createContent(CommonHandler.class.getResourceAsStream("templates/deb/postrm"), replacements));
                deb.setPrermScript(Contents.createContent(CommonHandler.class.getResourceAsStream("templates/deb/prerm"), replacements));
                deb.setPreinstScript(Contents.createContent(CommonHandler.class.getResourceAsStream("templates/deb/preinst"), replacements));
                context.scoopFiles(deb);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        finally {
            nodeDir.refreshLocal(2, monitor);
        }
    }

    private String findVersion() {
        ArrayList sortedChanges = new ArrayList(this.deploy.getChanges());
        if (sortedChanges.isEmpty()) {
            throw new IllegalStateException(String.format("No change record found", new Object[0]));
        }
        Collections.sort(sortedChanges, new ChangeEntryComparator(true));
        return ((ChangeEntry)sortedChanges.get(0)).getVersion();
    }

    private String createUserScriptCallbacks(File packageFolder, String type) throws IOException {
        File dir = new File(packageFolder, "src/usr/lib/eclipsescada/packagescripts/" + this.getPackageName() + "/" + type);
        if (!dir.isDirectory()) {
            return "";
        }
        StringWriter sw = new StringWriter();
        Charset cs = Charset.forName("UTF-8");
        Object[] files = dir.listFiles();
        Arrays.sort(files);
        Object[] objectArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            Object file = objectArray[n2];
            if (((File)file).isFile()) {
                sw.write(String.format("# ================== START - %s ==================\n", file));
                Throwable throwable = null;
                Object var12_13 = null;
                try (BufferedReader reader = Files.newBufferedReader(((File)file).toPath(), cs);){
                    CharStreams.copy((Readable)reader, (Appendable)sw);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                sw.write(String.format("# ==================  END - %s  ==================\n", file));
                ((File)file).setExecutable(true);
            }
            ++n2;
        }
        return sw.toString();
    }

    @Override
    protected StartupMechanism getDefaultStartupMechanism() {
        return StartupMechanism.UPSTART;
    }

    private String makeDependencies(Set<String> dependencies) {
        HashSet<String> result = new HashSet<String>();
        result.add("org.eclipse.scada");
        if (this.needP2()) {
            result.add("org.eclipse.scada.p2");
        }
        result.add("org.eclipse.scada.deploy.p2-incubation");
        result.addAll((Collection<String>)this.deploy.getAdditionalDependencies());
        StartupHandler sh = this.getStartupHandler();
        if (sh != null) {
            result.addAll(sh.getAdditionalPackageDependencies());
        }
        result.addAll(dependencies);
        return StringHelper.join(result, (String)", ");
    }

    private String createStopApps() {
        StringBuilder sb = new StringBuilder();
        this.stopApplications(sb);
        return sb.toString();
    }

    private String createStartApps() {
        StringBuilder sb = new StringBuilder();
        this.startApplications(sb);
        return sb.toString();
    }

    protected void startApplications(StringBuilder sb) {
        String cmd;
        StartupHandler sh = this.getStartupHandler();
        if (sh == null) {
            return;
        }
        for (String driver : this.makeDriverList()) {
            cmd = sh.startDriverCommand(driver);
            if (cmd == null) continue;
            sb.append(String.format("    %s || echo failed to start %s", cmd, driver));
            sb.append('\n');
        }
        if (this.deploy.isAutomaticCreate()) {
            for (String app : this.makeEquinoxList()) {
                cmd = sh.startEquinoxCommand(app);
                if (cmd == null) continue;
                sb.append(String.format("    %s || echo failed to start %s", cmd, app));
                sb.append('\n');
            }
        }
    }

    protected void stopApplications(StringBuilder sb) {
        String cmd;
        StartupHandler sh = this.getStartupHandler();
        if (sh == null) {
            return;
        }
        for (String driver : this.makeDriverList()) {
            cmd = sh.stopDriverCommand(driver);
            if (cmd == null) continue;
            sb.append(String.format("    %s || echo failed to stop %s", cmd, driver));
            sb.append('\n');
        }
        if (this.deploy.isAutomaticCreate()) {
            for (String app : this.makeEquinoxList()) {
                cmd = sh.stopEquinoxCommand(app);
                if (cmd == null) continue;
                sb.append(String.format("    %s || echo failed to stop %s", cmd, app));
                sb.append('\n');
            }
        }
    }
}

