/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.world.lib.deployment.startup;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.scada.configuration.world.lib.deployment.Contents;
import org.eclipse.scada.configuration.world.lib.deployment.DeploymentContext;
import org.eclipse.scada.configuration.world.lib.deployment.FileInformation;
import org.eclipse.scada.configuration.world.lib.deployment.FileOptions;
import org.eclipse.scada.configuration.world.lib.deployment.OperatingSystemDescriptors;
import org.eclipse.scada.configuration.world.lib.deployment.startup.StartupHandler;
import org.eclipse.scada.configuration.world.setup.OperatingSystemDescriptor;

public class UpstartHandler
implements StartupHandler {
    private final OperatingSystemDescriptor operatingSystem;

    public UpstartHandler(OperatingSystemDescriptor operatingSystem) {
        this.operatingSystem = operatingSystem;
    }

    protected boolean needScreenFix() {
        return OperatingSystemDescriptors.isProperty(this.operatingSystem, "screen.pre.start", false);
    }

    @Override
    public void createDriver(DeploymentContext context, String driverName, Map<String, String> replacements, IProgressMonitor monitor) throws Exception {
        context.addFile(Contents.createContent(UpstartHandler.class.getResourceAsStream("templates/upstart/driver.upstart.conf"), replacements), "/etc/init/scada.driver." + driverName + ".conf", new FileInformation(420, null, null, FileOptions.CONFIGURATION));
    }

    @Override
    public void createEquinox(DeploymentContext context, String appName, Map<String, String> replacements, IProgressMonitor monitor) throws Exception {
        if (this.needScreenFix()) {
            context.addFile(Contents.createContent(UpstartHandler.class.getResourceAsStream("templates/upstart/app.upstart.sf.conf"), replacements), "/etc/init/scada.app." + appName + ".conf", new FileInformation(420, null, null, FileOptions.CONFIGURATION));
        } else {
            context.addFile(Contents.createContent(UpstartHandler.class.getResourceAsStream("templates/upstart/app.upstart.conf"), replacements), "/etc/init/scada.app." + appName + ".conf", new FileInformation(420, null, null, FileOptions.CONFIGURATION));
        }
    }

    @Override
    public String startDriverCommand(String driverName) {
        return "start scada.driver." + driverName;
    }

    @Override
    public String stopDriverCommand(String driverName) {
        return "stop scada.driver." + driverName;
    }

    @Override
    public String startEquinoxCommand(String appName) {
        return "start scada.app." + appName;
    }

    @Override
    public String stopEquinoxCommand(String appName) {
        return "stop scada.app." + appName;
    }

    @Override
    public Set<String> getAdditionalPackageDependencies() {
        return Collections.singleton("screen");
    }
}

