/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.world.lib.oscar.item;

import java.util.HashMap;
import org.eclipse.scada.configuration.lib.Names;
import org.eclipse.scada.configuration.world.NamedDocumentable;
import org.eclipse.scada.configuration.world.lib.oscar.MasterHandlerPriorities;
import org.eclipse.scada.configuration.world.lib.oscar.OscarContext;
import org.eclipse.scada.configuration.world.lib.oscar.item.ItemGenerator;
import org.eclipse.scada.configuration.world.osgi.Item;
import org.eclipse.scada.configuration.world.osgi.SourceItem;

public class SourceItemGenerator
extends ItemGenerator {
    private final SourceItem item;

    public SourceItemGenerator(SourceItem item, OscarContext ctx, MasterHandlerPriorities priorities) {
        super((Item)item, ctx, priorities);
        this.item = item;
    }

    @Override
    public void generate() {
        super.generate();
        if (this.item.getConnection() == null) {
            throw new IllegalStateException(String.format("Item '%s' has no connection set", this.item.getName()));
        }
        this.addSource(this.makeSourceId(), this.item.getSourceName(), Names.makeName((NamedDocumentable)this.item.getConnection()));
    }

    @Override
    protected String makeSourceId() {
        return this.makeId("source");
    }

    protected void addSource(String id, String itemId, String connectionId) {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("item.id", itemId);
        data.put("connection.id", connectionId);
        this.addData("da.datasource.dataitem", id, data);
    }
}

