/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.world.lib.oscar.item.features;

import java.util.HashMap;
import org.eclipse.scada.ae.data.Severity;
import org.eclipse.scada.configuration.world.lib.oscar.MasterHandlerPriorities;
import org.eclipse.scada.configuration.world.lib.oscar.OscarContext;
import org.eclipse.scada.configuration.world.lib.oscar.item.Items;
import org.eclipse.scada.configuration.world.lib.oscar.item.features.Features;
import org.eclipse.scada.configuration.world.lib.oscar.item.features.ItemFeatureProcessor;
import org.eclipse.scada.configuration.world.osgi.ItemFeatureEntry;
import org.eclipse.scada.configuration.world.osgi.LevelMonitor;

public class LevelMonitorProcessor
implements ItemFeatureProcessor {
    @Override
    public void process(MasterHandlerPriorities priorities, ItemFeatureEntry rawFeature, OscarContext context) {
        LevelMonitor feature = (LevelMonitor)rawFeature;
        String configurationId = Features.configurationItem((ItemFeatureEntry)feature);
        Double preset = feature.getPreset();
        boolean cap = feature.isCap();
        boolean requireAck = feature.isRequireAck();
        boolean suppressEvents = feature.isSuppressEvents();
        Severity severity = feature.getSeverity();
        String demotePrefix = feature.getDemotePrefix();
        boolean lowerOk = feature.isLowerOk();
        boolean includedOk = feature.isIncludedOk();
        String monitorType = feature.getMonitorType();
        String type = feature.getPrefix();
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("active", "false");
        if (preset != null) {
            data.put("preset", "" + preset);
            data.put("active", "true");
        }
        data.put("cap", "" + cap);
        data.put("requireAck", "" + requireAck);
        if (suppressEvents) {
            data.put("suppressEvents", "" + suppressEvents);
        }
        data.put("severity", "" + severity);
        data.put("prefix", type);
        data.put("monitorType", monitorType);
        data.put("lowerOk", "" + lowerOk);
        data.put("includedOk", "" + includedOk);
        if (demotePrefix != null) {
            data.put("demote.prefix", demotePrefix);
        }
        int priority = priorities.findPriority("org.eclipse.scada.ae.monitor.level", configurationId);
        Items.fillForMasterHandler(data, feature.getItem(), priority);
        context.addData("org.eclipse.scada.ae.monitor.level", configurationId, data);
    }
}

