/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.world.lib.validator;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.eclipse.scada.configuration.world.lib.validator.DataSourceDescriptor;
import org.eclipse.scada.configuration.world.lib.validator.DataSourceNode;
import org.eclipse.scada.configuration.world.lib.validator.DataSourceReference;
import org.eclipse.scada.configuration.world.lib.validator.handler.AverageHandler;
import org.eclipse.scada.configuration.world.lib.validator.handler.FormulaHandler;
import org.eclipse.scada.configuration.world.lib.validator.handler.LoopHandler;
import org.eclipse.scada.configuration.world.lib.validator.handler.MapperHandler;
import org.eclipse.scada.configuration.world.lib.validator.handler.MasterHandler;
import org.eclipse.scada.configuration.world.lib.validator.handler.MovingAverageHandler;
import org.eclipse.scada.configuration.world.lib.validator.handler.MultiSourceAttributeHandler;
import org.eclipse.scada.configuration.world.lib.validator.handler.NoOpHandler;
import org.eclipse.scada.configuration.world.lib.validator.handler.ProxyQueryHandler;
import org.eclipse.scada.configuration.world.lib.validator.handler.SimpleAttributeHandler;
import org.eclipse.scada.configuration.world.lib.validator.handler.SimpleHandler;
import org.eclipse.scada.configuration.world.lib.validator.handler.SummaryHandler;
import org.eclipse.scada.utils.str.StringHelper;

public class LoopValidator {
    private final Map<String, LoopHandler> handlers = new HashMap<String, LoopHandler>();
    private final Map<String, Map<String, Map<String, String>>> data;
    private final PrintStream logStream;
    private final Set<DataSourceDescriptor> descriptorPool = new HashSet<DataSourceDescriptor>();

    public LoopValidator(Map<String, Map<String, Map<String, String>>> data, PrintStream logStream) {
        this.data = data;
        this.logStream = logStream;
        this.initLoopHandler();
        this.initFixedSources();
    }

    private void initFixedSources() {
        this.descriptorPool.add(new DataSourceDescriptor("datasource", "ae.server.info.NOT_AKN"));
        this.descriptorPool.add(new DataSourceDescriptor("datasource", "ae.server.info.OK"));
        this.descriptorPool.add(new DataSourceDescriptor("datasource", "ae.server.info.INIT"));
        this.descriptorPool.add(new DataSourceDescriptor("datasource", "ae.server.info.ALERT_ACTIVE"));
        this.descriptorPool.add(new DataSourceDescriptor("datasource", "ae.server.info.ALERT_DISABLED"));
        this.descriptorPool.add(new DataSourceDescriptor("datasource", "ae.server.info.NOT_OK_NOT_AKN"));
        this.descriptorPool.add(new DataSourceDescriptor("datasource", "ae.server.info.UNSAFE"));
        this.descriptorPool.add(new DataSourceDescriptor("datasource", "ae.server.info.INACTIVE"));
        this.descriptorPool.add(new DataSourceDescriptor("datasource", "ae.server.info.NOT_OK_AKN"));
        this.descriptorPool.add(new DataSourceDescriptor("datasource", "ae.server.info.NOT_OK"));
    }

    private void initLoopHandler() {
        this.handlers.put("ae.server.info", new NoOpHandler());
        this.handlers.put("org.eclipse.scada.da.server.exporter.rest", new NoOpHandler());
        this.handlers.put("org.eclipse.scada.da.server.exporter.modbus.device", new NoOpHandler());
        this.handlers.put("org.eclipse.scada.sec.osgi.manager", new NoOpHandler());
        this.handlers.put("org.eclipse.scada.ae.event.logger", new NoOpHandler());
        this.handlers.put("org.eclipse.scada.ae.server.http.eventFilter", new NoOpHandler());
        this.handlers.put("org.eclipse.scada.sec.provider.jdbc.authenticator", new NoOpHandler());
        this.handlers.put("ae.monitor.query", new SimpleHandler("monitor.query"));
        this.handlers.put("org.eclipse.scada.ae.server.common.event.pool", new SimpleHandler("event.query"));
        this.handlers.put("da.connection", new SimpleHandler("da.connection"));
        this.handlers.put("ae.connection", new SimpleHandler("ae.connection"));
        this.handlers.put("hd.connection", new SimpleHandler("hd.connection"));
        this.handlers.put("org.eclipse.scada.da.datasource.average", new AverageHandler());
        this.handlers.put("org.eclipse.scada.da.datasource.movingaverage", new MovingAverageHandler());
        this.handlers.put("da.dataitem.datasource", new SimpleAttributeHandler("datasource", "da.connection", "connection.id"));
        this.handlers.put("master.item", new MasterHandler());
        this.handlers.put("da.datasource.dataitem", new SimpleHandler("datasource"));
        this.handlers.put("org.eclipse.scada.da.datasource.script", new MultiSourceAttributeHandler("datasource."));
        this.handlers.put("org.eclipse.scada.da.datasource.sum", new MultiSourceAttributeHandler("datasource.", "subDatasource."));
        this.handlers.put("org.eclipse.scada.da.datasource.ds", new SimpleHandler("datasource"));
        this.handlers.put("org.eclipse.scada.da.datasource.constant", new SimpleHandler("datasource"));
        this.handlers.put("org.eclipse.scada.da.server.osgi.summary.attribute", new SummaryHandler());
        this.handlers.put("org.eclipse.scada.da.datasource.formula", new FormulaHandler());
        this.handlers.put("org.eclipse.scada.ae.monitor.level", new SimpleAttributeHandler("masterHandler", "master", "master.id"));
        this.handlers.put("org.eclipse.scada.ae.monitor.bit", new SimpleAttributeHandler("masterHandler", "master", "master.id"));
        this.handlers.put("org.eclipse.scada.ae.monitor.list", new SimpleAttributeHandler("masterHandler", "master", "master.id"));
        this.handlers.put("org.eclipse.scada.da.master.common.marker", new SimpleAttributeHandler("masterHandler", "master", "master.id", ", ?"));
        this.handlers.put("org.eclipse.scada.da.level.ceil", new SimpleAttributeHandler("masterHandler", "master", "master.id"));
        this.handlers.put("org.eclipse.scada.da.level.highhigh", new SimpleAttributeHandler("masterHandler", "master", "master.id"));
        this.handlers.put("org.eclipse.scada.da.level.high", new SimpleAttributeHandler("masterHandler", "master", "master.id"));
        this.handlers.put("org.eclipse.scada.da.level.low", new SimpleAttributeHandler("masterHandler", "master", "master.id"));
        this.handlers.put("org.eclipse.scada.da.level.lowlow", new SimpleAttributeHandler("masterHandler", "master", "master.id"));
        this.handlers.put("da.master.handler.sum", new SimpleAttributeHandler("masterHandler", "datasource", "master.id"));
        this.handlers.put("org.eclipse.scada.da.negate.input", new SimpleAttributeHandler("masterHandler", "master", "master.id"));
        this.handlers.put("org.eclipse.scada.da.manual", new SimpleAttributeHandler("masterHandler", "master", "master.id"));
        this.handlers.put("org.eclipse.scada.da.master.common.block", new SimpleAttributeHandler("masterHandler", "master", "master.id", ", ?"));
        this.handlers.put("org.eclipse.scada.da.round", new SimpleAttributeHandler("masterHandler", "master", "master.id"));
        this.handlers.put("org.eclipse.scada.da.mapper.osgi.configuredMapper", new SimpleHandler("mapper"));
        this.handlers.put("org.eclipse.scada.da.mapper.osgi.jdbcMapper", new SimpleHandler("mapper"));
        this.handlers.put("org.eclipse.scada.da.master.mapper", new MapperHandler());
        this.handlers.put("org.eclipse.scada.da.scale.input", new SimpleAttributeHandler("masterHandler", "master", "master.id"));
        this.handlers.put("org.eclipse.scada.ae.server.monitor.proxy", new ProxyQueryHandler("monitor.query"));
        this.handlers.put("org.eclipse.scada.ae.server.event.proxy", new ProxyQueryHandler("event.query"));
    }

    public void validate() {
        Set<DataSourceNode> nodes = this.load();
        this.searchForLoops(nodes);
    }

    public void writeDot(File dotFile) throws FileNotFoundException {
        Set<DataSourceNode> nodes = this.load();
        System.out.println("Writing to: " + dotFile);
        PrintWriter writer = new PrintWriter(dotFile);
        writer.println("digraph {");
        writer.println("  rankdir=LR");
        for (DataSourceNode node : nodes) {
            if (!"datasource".equals(node.getType())) continue;
            writer.println(String.format("\"%s\"", node.getId()));
            writer.println();
        }
        for (DataSourceNode node : nodes) {
            if (!"datasource".equals(node.getType())) continue;
            for (DataSourceNode refNode : node.getReferences()) {
                writer.println(String.format("\"%s\" -> \"%s\"", node.getId(), refNode.getId()));
            }
            writer.println();
        }
        writer.println("}");
        writer.close();
    }

    private Set<DataSourceNode> load() {
        for (Map.Entry<String, Map<String, Map<String, String>>> factory : this.data.entrySet()) {
            this.processFactory(factory.getKey(), factory.getValue());
        }
        for (LoopHandler handler : this.handlers.values()) {
            if (!handler.providesPostProcessing()) continue;
            handler.postProcess(this.descriptorPool);
        }
        this.logStream.println(String.format("%s nodes in validation pool", this.descriptorPool.size()));
        Set<DataSourceNode> nodes = this.buildGraph();
        return nodes;
    }

    private void searchForLoops(Set<DataSourceNode> nodes) {
        for (DataSourceNode node : nodes) {
            Stack<DataSourceNode> stack = new Stack<DataSourceNode>();
            this.walk(stack, node);
        }
    }

    private void walk(Stack<DataSourceNode> stack, DataSourceNode node) {
        if (stack.contains(node)) {
            this.logStream.println("Loop found: " + StringHelper.join(stack, (String)" -> "));
            return;
        }
        stack.push(node);
        for (DataSourceNode ref : node.getReferences()) {
            this.walk(stack, ref);
        }
        stack.pop();
    }

    private Set<DataSourceNode> buildGraph() {
        DataSourceNode node;
        HashMap<DataSourceDescriptor, DataSourceNode> nodes = new HashMap<DataSourceDescriptor, DataSourceNode>();
        for (DataSourceDescriptor desc : this.descriptorPool) {
            node = new DataSourceNode(desc.getType(), desc.getId());
            nodes.put(desc, node);
        }
        for (DataSourceDescriptor desc : this.descriptorPool) {
            node = (DataSourceNode)nodes.get(desc);
            for (DataSourceReference reference : desc.getReferences()) {
                DataSourceNode ref = (DataSourceNode)nodes.get(reference);
                if (ref == null) {
                    this.logStream.println(String.format("Reference from %s to %s not found", desc, reference));
                    continue;
                }
                node.addReference(ref);
            }
        }
        return new HashSet<DataSourceNode>(nodes.values());
    }

    private void processFactory(String factoryId, Map<String, Map<String, String>> value) {
        LoopHandler handler = this.handlers.get(factoryId);
        if (handler == null) {
            this.logStream.println("Ignoring factory: " + factoryId);
            return;
        }
        if (!handler.providesDescriptors()) {
            return;
        }
        for (Map.Entry<String, Map<String, String>> configuration : value.entrySet()) {
            this.processConfiguration(handler, factoryId, configuration.getKey(), configuration.getValue());
        }
    }

    private void processConfiguration(LoopHandler handler, String factoryId, String configurationId, Map<String, String> parameters) {
        Set<DataSourceDescriptor> descriptors = handler.getNode(configurationId, parameters);
        for (DataSourceDescriptor desc : descriptors) {
            if (this.descriptorPool.add(desc)) continue;
            this.logStream.println("Duplicate data source: " + desc.getId());
        }
    }
}

