/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.component.osgi;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.eclipse.scada.da.server.component.ComponentFactory;
import org.eclipse.scada.da.server.component.ComponentHandle;
import org.eclipse.scada.da.server.component.ComponentHost;
import org.eclipse.scada.utils.concurrent.NamedThreadFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class OsgiFactory {
    private final ExecutorService executor;
    private final ServiceTracker<ComponentFactory, ComponentFactory> tracker;
    private final ServiceTrackerCustomizer<ComponentFactory, ComponentFactory> customizer = new ServiceTrackerCustomizer<ComponentFactory, ComponentFactory>(){

        public void removedService(ServiceReference<ComponentFactory> reference, ComponentFactory service) {
            OsgiFactory.this.handleRemovedService(reference);
        }

        public void modifiedService(ServiceReference<ComponentFactory> reference, ComponentFactory service) {
            OsgiFactory.this.handleRemovedService(reference);
            OsgiFactory.this.handleAddingService(reference, service);
        }

        public ComponentFactory addingService(ServiceReference<ComponentFactory> reference) {
            ComponentFactory service = (ComponentFactory)OsgiFactory.this.context.getService(reference);
            if (OsgiFactory.this.handleAddingService(reference, service) == null) {
                OsgiFactory.this.context.ungetService(reference);
                return null;
            }
            return service;
        }
    };
    private final BundleContext context;
    private final ComponentHost componentHost;
    private final Map<ServiceReference<ComponentFactory>, ComponentHandle> refMap = new ConcurrentHashMap<ServiceReference<ComponentFactory>, ComponentHandle>();

    public OsgiFactory(BundleContext context, ComponentHost componentHost) {
        this.componentHost = componentHost;
        this.context = context;
        this.executor = Executors.newSingleThreadExecutor((ThreadFactory)new NamedThreadFactory("org.eclipse.scada.da.server.component.osgi"));
        this.tracker = new ServiceTracker(context, ComponentFactory.class, this.customizer);
        this.tracker.open();
    }

    public void dispose() {
        this.tracker.close();
        this.executor.shutdown();
    }

    protected ComponentFactory handleAddingService(ServiceReference<ComponentFactory> reference, ComponentFactory service) {
        try {
            ComponentHandle handle = this.componentHost.registerComponent(service);
            this.refMap.put(reference, handle);
            return service;
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected void handleRemovedService(ServiceReference<ComponentFactory> ref) {
        ComponentHandle handle = this.refMap.remove(ref);
        if (handle != null) {
            handle.unregister();
        }
    }
}

