/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.hd.server.net;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.scada.hd.Query;
import org.eclipse.scada.hd.QueryListener;
import org.eclipse.scada.hd.QueryState;
import org.eclipse.scada.hd.data.QueryParameters;
import org.eclipse.scada.hd.data.ValueInformation;
import org.eclipse.scada.hd.server.net.ServerConnectionHandler;

public class QueryHandler
implements QueryListener {
    private Query query;
    private final ServerConnectionHandler connectionHandler;
    private final long id;

    public QueryHandler(long id, ServerConnectionHandler connectionHandler) {
        this.id = id;
        this.connectionHandler = connectionHandler;
    }

    public void updateData(int index, Map<String, List<Double>> values, List<ValueInformation> valueInformation) {
        this.connectionHandler.sendQueryData(this.id, index, values, valueInformation);
    }

    public void updateParameters(QueryParameters parameters, Set<String> valueTypes) {
        this.connectionHandler.sendQueryParameters(this.id, parameters, valueTypes);
    }

    public void updateState(QueryState state) {
        this.connectionHandler.sendQueryState(this.id, state);
    }

    public void setQuery(Query query) {
        this.query = query;
    }

    public void close() {
        if (this.query != null) {
            this.query.close();
        }
    }

    public void changeParameters(QueryParameters parameters) {
        this.query.changeParameters(parameters);
    }
}

