/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.protocol.ngp.common.mc.frame;

import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.CumulativeProtocolDecoder;
import org.apache.mina.filter.codec.ProtocolDecoderOutput;
import org.eclipse.scada.protocol.ngp.common.mc.frame.Frame;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FrameDecoder
extends CumulativeProtocolDecoder {
    private static final int HEADER_SIZE = 6;
    private static final Logger logger = LoggerFactory.getLogger(FrameDecoder.class);

    protected boolean doDecode(IoSession session, IoBuffer data, ProtocolDecoderOutput output) throws Exception {
        logger.trace("decode data - session: {}, data: {}", (Object)session, (Object)data);
        if (data.remaining() < 6) {
            return false;
        }
        int position = data.position();
        byte version = data.get(position);
        if (version != 1) {
            throw new IllegalStateException(String.format("Version 0x%02x is not supported.", version));
        }
        byte frameTypeOrdinal = data.get(position + 1);
        Frame.FrameType frameType = Frame.FrameType.values()[frameTypeOrdinal];
        int dataLength = data.getInt(position + 2);
        logger.trace("Data length: {}, remainingData: {}", (Object)dataLength, (Object)(data.remaining() - 6));
        if (data.remaining() < 6 + dataLength) {
            return false;
        }
        data.get();
        data.get();
        data.getInt();
        IoBuffer frameData = data.getSlice(dataLength);
        Frame frame = new Frame(frameType, frameData);
        logger.trace("Decoded frame: {} ... {} bytes remaining", (Object)frame, (Object)data.remaining());
        output.write((Object)frame);
        return true;
    }
}

