/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.sec.osgi;

import org.eclipse.scada.sec.AuthenticationException;
import org.eclipse.scada.sec.AuthenticationImplementation;
import org.eclipse.scada.sec.StatusCodes;
import org.eclipse.scada.sec.UserInformation;
import org.eclipse.scada.sec.callback.CallbackHandler;
import org.eclipse.scada.sec.osgi.Messages;
import org.eclipse.scada.utils.concurrent.InstantErrorFuture;
import org.eclipse.scada.utils.concurrent.NotifyFuture;
import org.eclipse.scada.utils.osgi.SingleServiceTracker;
import org.osgi.framework.BundleContext;

public class TrackingAuthenticationImplementation
implements AuthenticationImplementation {
    private final SingleServiceTracker<AuthenticationImplementation> tracker;

    public TrackingAuthenticationImplementation(BundleContext context) {
        this.tracker = new SingleServiceTracker(context, AuthenticationImplementation.class, null);
    }

    public void open() {
        this.tracker.open();
    }

    public void close() {
        this.tracker.close();
    }

    public UserInformation getUser(String user) {
        AuthenticationImplementation service = (AuthenticationImplementation)this.tracker.getService();
        if (service == null) {
            return null;
        }
        return service.getUser(user);
    }

    public NotifyFuture<UserInformation> authenticate(CallbackHandler callbackHandler) {
        AuthenticationImplementation service = (AuthenticationImplementation)this.tracker.getService();
        if (service == null) {
            return new InstantErrorFuture((Throwable)new AuthenticationException(StatusCodes.AUTHORIZATION_FAILED, Messages.getString("TrackingAuthenticationImplementation.DefaultMessage")));
        }
        return service.authenticate(callbackHandler);
    }
}

