/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.base.extractor.extract.pattern;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.scada.base.extractor.extract.ItemDescriptor;
import org.eclipse.scada.base.extractor.extract.ItemValue;
import org.eclipse.scada.base.extractor.extract.pattern.AbstractPatternExtractor;
import org.eclipse.scada.base.extractor.extract.pattern.ValueFieldDescriptor;
import org.eclipse.scada.core.Variant;

public class MultiPatternExtractor
extends AbstractPatternExtractor {
    private final Pattern pattern;
    private final Fields fields;
    private static ItemDescriptor DESC_VALUE;

    static {
        HashMap<String, Variant> attributes = new HashMap<String, Variant>(1);
        attributes.put("description", Variant.valueOf((Object)"Result value"));
        DESC_VALUE = new ItemDescriptor("value", attributes);
    }

    public MultiPatternExtractor(Pattern pattern, Fields fields) {
        this.pattern = pattern;
        this.fields = fields;
    }

    @Override
    protected Map<ItemDescriptor, ItemValue> processData(String data) throws Exception {
        HashMap<ItemDescriptor, ItemValue> result = new HashMap<ItemDescriptor, ItemValue>();
        Matcher m = this.pattern.matcher(data);
        boolean match = m.matches();
        if (match) {
            this.fields.buildResult(result, m);
        } else {
            result.put(DESC_VALUE, new ItemValue(Variant.NULL, NO_MATCH_ATTRIBUTES));
        }
        result.put(DESC_STATE, this.makeState(m, match, true, data));
        return result;
    }

    public static class Fields {
        private final Map<ItemDescriptor, ValueFieldDescriptor> fields;

        public Fields(Map<ItemDescriptor, ValueFieldDescriptor> fields) {
            this.fields = fields;
        }

        public Map<ItemDescriptor, ValueFieldDescriptor> getFields() {
            return this.fields;
        }

        public void buildResult(Map<ItemDescriptor, ItemValue> result, Matcher m) throws Exception {
            for (Map.Entry<ItemDescriptor, ValueFieldDescriptor> entry : this.fields.entrySet()) {
                result.put(entry.getKey(), entry.getValue().buildValue(m));
            }
        }
    }
}

