/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.base.extractor.extract.pattern;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.scada.base.extractor.extract.ItemDescriptor;
import org.eclipse.scada.base.extractor.extract.ItemValue;
import org.eclipse.scada.base.extractor.extract.pattern.AbstractPatternExtractor;
import org.eclipse.scada.base.extractor.extract.pattern.FieldSpec;
import org.eclipse.scada.base.extractor.extract.pattern.ValueFieldDescriptor;
import org.eclipse.scada.core.Variant;

public class SinglePatternExtractor
extends AbstractPatternExtractor {
    private final Pattern pattern;
    private final ValueFieldDescriptor fieldDescriptor;
    private final boolean fullMatch;
    private static ItemDescriptor DESC_VALUE;

    static {
        HashMap<String, Variant> attributes = new HashMap<String, Variant>(1);
        attributes.put("description", Variant.valueOf((Object)"Result value"));
        DESC_VALUE = new ItemDescriptor("value", attributes);
    }

    public SinglePatternExtractor(Pattern pattern, boolean fullMatch, ValueFieldDescriptor fieldDescriptor) {
        this.pattern = pattern;
        this.fullMatch = fullMatch;
        this.fieldDescriptor = fieldDescriptor;
    }

    public SinglePatternExtractor(Pattern pattern, boolean fullMatch, FieldSpec primaryValue, Map<String, FieldSpec> attributes) {
        this(pattern, fullMatch, new ValueFieldDescriptor(primaryValue, attributes));
    }

    @Override
    protected Map<ItemDescriptor, ItemValue> processData(String data) throws Exception {
        HashMap<ItemDescriptor, ItemValue> result = new HashMap<ItemDescriptor, ItemValue>();
        Matcher m = this.pattern.matcher(data);
        boolean match = this.fullMatch ? m.matches() : m.find();
        if (match) {
            result.put(DESC_VALUE, this.fieldDescriptor.buildValue(m));
        } else {
            result.put(DESC_VALUE, new ItemValue(Variant.NULL, NO_MATCH_ATTRIBUTES));
        }
        result.put(DESC_STATE, this.makeState(m, match, this.fullMatch, data));
        return result;
    }
}

