/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.base.extractor.input.process;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.scada.base.extractor.input.process.ReaderThread;

public class CaptureOutputThread
extends ReaderThread {
    private ByteArrayOutputStream bos;
    private IOException error;

    public CaptureOutputThread(InputStream stream) {
        super(stream);
    }

    @Override
    public void run() {
        this.bos = new ByteArrayOutputStream();
        super.run();
    }

    @Override
    protected void handleComplete() {
        try {
            this.bos.close();
        }
        catch (IOException e) {
            this.error = e;
        }
    }

    @Override
    protected void handleData(byte[] buffer, int len) {
        this.bos.write(buffer, 0, len);
    }

    @Override
    protected void handleError(IOException e) {
        this.error = e;
    }

    public IOException getError() {
        return this.error;
    }

    public byte[] getData() {
        if (this.error == null && this.bos != null) {
            return this.bos.toByteArray();
        }
        return null;
    }
}

