/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.validation.component;

import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.validation.AbstractModelConstraint;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.emf.validation.model.ConstraintStatus;
import org.eclipse.scada.configuration.component.Component;
import org.eclipse.scada.configuration.component.ComponentReferenceInputDefinition;
import org.eclipse.scada.configuration.component.DataComponent;
import org.eclipse.scada.configuration.component.lib.create.CaptureItemCreator;
import org.eclipse.scada.configuration.component.lib.create.ItemCreator;
import org.eclipse.scada.configuration.component.lib.create.ItemSource;
import org.eclipse.scada.configuration.component.lib.create.ItemSources;
import org.eclipse.scada.configuration.infrastructure.MasterServer;

public class ComponentReferenceValidation
extends AbstractModelConstraint {
    public IStatus validate(IValidationContext ctx) {
        if (!(ctx.getTarget() instanceof ComponentReferenceInputDefinition)) {
            return ctx.createSuccessStatus();
        }
        ComponentReferenceInputDefinition ref = (ComponentReferenceInputDefinition)ctx.getTarget();
        LinkedList<IStatus> result = new LinkedList<IStatus>();
        this.validate(ref, ctx, result);
        if (result.isEmpty()) {
            return ctx.createSuccessStatus();
        }
        if (result.size() == 1) {
            return (IStatus)result.get(0);
        }
        return ConstraintStatus.createMultiStatus((IValidationContext)ctx, result);
    }

    private void validate(ComponentReferenceInputDefinition ref, IValidationContext ctx, List<IStatus> result) {
        if (!(ref.eContainer() instanceof DataComponent)) {
            return;
        }
        if (!(ref.getComponent() instanceof DataComponent)) {
            return;
        }
        DataComponent dc = (DataComponent)ref.eContainer();
        DataComponent refComp = (DataComponent)ref.getComponent();
        for (MasterServer m : dc.getMasterOn()) {
            if (refComp.getMasterOn().contains((Object)m)) continue;
            result.add((IStatus)ConstraintStatus.createStatus((IValidationContext)ctx, Arrays.asList(ref), (int)4, (int)1, (String)"\"{0}\" of data component \"{1}\" references to a component \"{2}\" that is not available on the master server \"'{3}\".", (Object[])new Object[]{ref, dc, refComp, m}));
        }
        for (MasterServer m : dc.getMasterOn()) {
            this.validateRef(m, ref, ctx, result);
        }
    }

    private Map<List<String>, CaptureItemCreator.ItemCreation> createItems(Component component) {
        HashMap<List<String>, CaptureItemCreator.ItemCreation> result = new HashMap<List<String>, CaptureItemCreator.ItemCreation>();
        ItemSource source = ItemSources.createItemSource((Component)component);
        CaptureItemCreator creator = new CaptureItemCreator(component, result);
        source.createItems((ItemCreator)creator);
        return result;
    }

    private void validateRef(MasterServer m, ComponentReferenceInputDefinition ref, IValidationContext ctx, List<IStatus> result) {
        Map<List<String>, CaptureItemCreator.ItemCreation> itemResult = this.createItems(ref.getComponent());
        CaptureItemCreator.ItemCreation refItem = itemResult.get(ref.getLocalTag());
        if (refItem == null) {
            result.add((IStatus)ConstraintStatus.createStatus((IValidationContext)ctx, Arrays.asList(ref), (int)4, (int)2, (String)"The reference points to an invalid item (LocalTags: {0}) on the component: {1}", (Object[])new Object[]{ref.getLocalTag(), ref.getComponent()}));
        }
    }
}

