/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.validation.ocl;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.emf.validation.ocl.AbstractOCLModelConstraint;
import org.eclipse.emf.validation.service.IConstraintDescriptor;
import org.eclipse.ocl.EnvironmentFactory;
import org.eclipse.ocl.Query;
import org.eclipse.ocl.ecore.Constraint;
import org.eclipse.ocl.ecore.OCL;
import org.eclipse.scada.configuration.validation.ocl.OCLConstraintDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OCLConstraint
extends AbstractOCLModelConstraint<EClassifier, Constraint, EClass, EObject> {
    private static final Logger logger = LoggerFactory.getLogger(OCLConstraint.class);
    private final OCL.Query query;

    OCLConstraint(OCLConstraintDescriptor desc, OCL ocl) {
        super((IConstraintDescriptor)desc);
        this.query = ocl.createQuery(desc.getConstraint());
    }

    protected EnvironmentFactory<?, EClassifier, ?, ?, ?, ?, ?, ?, ?, Constraint, EClass, EObject> createOCLEnvironmentFactory() {
        return this.query.getOCL().getEnvironment().getFactory();
    }

    public Query<EClassifier, EClass, EObject> getConstraintCondition(EObject target) {
        return this.query;
    }

    public IStatus validate(IValidationContext ctx) {
        IStatus result = super.validate(ctx);
        logger.debug("Validating - this: {}, result: {}, ctx: {}", new Object[]{this, result, ctx});
        return result;
    }

    public String toString() {
        return this.query.queryText();
    }
}

