/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.validation.ocl;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.validation.model.Category;
import org.eclipse.emf.validation.model.CategoryManager;
import org.eclipse.emf.validation.service.AbstractConstraintProvider;
import org.eclipse.emf.validation.service.ConstraintExistsException;
import org.eclipse.emf.validation.service.IConstraintDescriptor;
import org.eclipse.ocl.OCLInput;
import org.eclipse.ocl.ParserException;
import org.eclipse.ocl.ecore.Constraint;
import org.eclipse.ocl.ecore.OCL;
import org.eclipse.scada.configuration.validation.internal.ValidationPlugin;
import org.eclipse.scada.configuration.validation.ocl.OCLConstraint;
import org.eclipse.scada.configuration.validation.ocl.OCLConstraintDescriptor;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OCLConstraintProvider
extends AbstractConstraintProvider {
    private static final Logger logger = LoggerFactory.getLogger(OCLConstraintProvider.class);
    private static final String E_OCL = "ocl";
    private static final String A_PATH = "path";
    private static final String A_CATEGORY = "category";

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        super.setInitializationData(config, propertyName, data);
        logger.debug("Initialize");
        String categoryID = config.getDeclaringExtension().getUniqueIdentifier();
        if (categoryID == null) {
            categoryID = "OCLProvider@" + Long.toHexString(System.identityHashCode((Object)this));
        }
        categoryID = "org.eclipse.scada.configuration/" + categoryID;
        logger.debug("Category ID: {}", (Object)categoryID);
        Category category = CategoryManager.getInstance().getCategory(categoryID);
        category.setName(config.getAttribute(A_CATEGORY));
        Bundle contributor = Platform.getBundle((String)config.getDeclaringExtension().getNamespaceIdentifier());
        IConfigurationElement[] ocls = config.getChildren(E_OCL);
        int i = 0;
        while (i < ocls.length) {
            String path = ocls[i].getAttribute(A_PATH);
            if (path != null && path.length() > 0) {
                Path ipath = new Path(path);
                logger.debug("Loading: {}", (Object)ipath);
                this.parseConstraints(CategoryManager.getInstance().getCategory(category, ipath.lastSegment()), contributor, path);
            }
            ++i;
        }
        try {
            List contraints = this.getConstraints();
            logger.debug("Registering {} constraints", (Object)contraints.size());
            this.registerConstraints(contraints);
        }
        catch (ConstraintExistsException e) {
            throw new CoreException((IStatus)new Status(4, ValidationPlugin.getID(), 1, "Registration of OCL constraints failed", (Throwable)e));
        }
    }

    private void parseConstraints(Category category, Bundle bundle, String path) {
        logger.debug("Category: {}", (Object)category);
        String baseName = path.replaceFirst("\\.ocl", "");
        logger.debug("Loading resources from: {}", (Object)baseName);
        ResourceBundle messages = null;
        try {
            messages = ResourceBundle.getBundle(baseName, Locale.getDefault(), OCLConstraintProvider.class.getClassLoader());
        }
        catch (MissingResourceException e) {
            logger.debug("Failed to load resources", (Throwable)e);
        }
        URL url = bundle.getEntry(path);
        if (url != null) {
            try (InputStream input = url.openStream();){
                try {
                    this.parseConstraints(category, bundle.getSymbolicName(), input, messages);
                }
                catch (ParserException e) {
                    String msg = String.format("Failed to parse OCL constraints in %s:%s", bundle.getSymbolicName(), path);
                    ValidationPlugin.log(msg, e);
                    input.close();
                }
            }
            catch (IOException e) {
                String msg = String.format("Failed to load OCL constraints from %s:%s", bundle.getSymbolicName(), path);
                ValidationPlugin.log(msg, e);
            }
        }
    }

    private void parseConstraints(Category category, String namespace, InputStream input, ResourceBundle messages) throws ParserException {
        OCLInput oclInput = new OCLInput(input);
        OCL ocl = OCL.newInstance();
        for (Constraint constraint : ocl.parse(oclInput)) {
            if (!this.isInvariant(constraint)) continue;
            this.addConstraint(category, namespace, ocl, constraint, messages);
        }
    }

    private boolean isInvariant(Constraint constraint) {
        return "invariant".equals(constraint.getStereotype());
    }

    private void addConstraint(Category category, String namespace, OCL ocl, Constraint constraint, ResourceBundle messages) {
        List constraints = this.getConstraints();
        OCLConstraintDescriptor desc = new OCLConstraintDescriptor(namespace, constraint, constraints.size() + 1, messages);
        if (category != null) {
            category.addConstraint((IConstraintDescriptor)desc);
        }
        constraints.add(new OCLConstraint(desc, ocl));
        logger.debug("Added contraint: {}, {}", (Object)ocl, (Object)desc);
    }
}

