/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.validation.world.deployment;

import java.util.Collection;
import java.util.LinkedList;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.AbstractModelConstraint;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.emf.validation.model.ConstraintStatus;
import org.eclipse.scada.configuration.world.deployment.CommonDeploymentMechanism;
import org.eclipse.scada.configuration.world.setup.OperatingSystemDescriptor;
import org.eclipse.scada.configuration.world.setup.SetupModule;
import org.eclipse.scada.configuration.world.setup.SetupModuleContainer;

public class DeploymentSetupValidator
extends AbstractModelConstraint {
    public IStatus validate(IValidationContext ctx) {
        if (ctx.getTarget() instanceof CommonDeploymentMechanism) {
            CommonDeploymentMechanism dep = (CommonDeploymentMechanism)ctx.getTarget();
            SetupModuleContainer smc = dep.getSetup();
            OperatingSystemDescriptor os = dep.getOperatingSystem();
            LinkedList<ConstraintStatus> result = new LinkedList<ConstraintStatus>();
            if (smc != null && os == null) {
                result.add(ConstraintStatus.createStatus((IValidationContext)ctx, (EObject)ctx.getTarget(), null, (String)"The deployment mechansim has a setup module container set but no operating system assigned", (Object[])new Object[0]));
            } else if (smc != null) {
                this.addResult(result, smc.validateOperatingSystem(os, ctx));
            }
            if (dep.getAdditionalSetupModules() != null && !dep.getAdditionalSetupModules().isEmpty() && os == null) {
                result.add(ConstraintStatus.createStatus((IValidationContext)ctx, (EObject)ctx.getTarget(), null, (String)"The deployment mechansim has a additional setup modules but no operating system assigned", (Object[])new Object[0]));
            } else if (smc != null) {
                for (SetupModule sm : dep.getAdditionalSetupModules()) {
                    this.addResult(result, sm.validateOperatingSystem(os, ctx));
                }
            }
            if (result.isEmpty()) {
                return ctx.createSuccessStatus();
            }
            if (result.size() == 1) {
                return (IStatus)result.getFirst();
            }
            return ConstraintStatus.createMultiStatus((IValidationContext)ctx, result);
        }
        return ctx.createSuccessStatus();
    }

    private void addResult(Collection<? super IStatus> result, IStatus status) {
        if (status == null || status.isOK()) {
            return;
        }
        result.add((IStatus)status);
    }
}

