/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.protocol.ngp.common.mc;

import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.filterchain.IoFilterAdapter;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.core.write.WriteRequest;
import org.apache.mina.core.write.WriteRequestWrapper;
import org.eclipse.scada.protocol.ngp.common.mc.message.DataMessage;
import org.eclipse.scada.protocol.ngp.common.mc.protocol.MessageProtocol;

public class DataMessageFilter
extends IoFilterAdapter {
    private final MessageProtocol messageProtocol;

    public DataMessageFilter(MessageProtocol messageProtocol) {
        if (messageProtocol == null) {
            throw new IllegalArgumentException("'messageProtocol' must not be null");
        }
        this.messageProtocol = messageProtocol;
    }

    public void filterWrite(IoFilter.NextFilter nextFilter, IoSession session, WriteRequest writeRequest) throws Exception {
        final DataMessage message = this.messageProtocol.getEncoder().encodeMessage(writeRequest.getMessage());
        nextFilter.filterWrite(session, (WriteRequest)new WriteRequestWrapper(writeRequest){

            public Object getMessage() {
                return message;
            }
        });
    }

    public void messageReceived(IoFilter.NextFilter nextFilter, IoSession session, Object message) throws Exception {
        if (!(message instanceof DataMessage)) {
            throw new IllegalStateException(String.format("Can only handle messages of type %s. This message is: %s", DataMessage.class, message.getClass()));
        }
        nextFilter.messageReceived(session, this.messageProtocol.getDecoder().decodeMessage((DataMessage)message));
    }
}

