/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.protocol.ngp.common.mc;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.filterchain.IoFilterAdapter;
import org.apache.mina.core.filterchain.IoFilterChain;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.core.write.DefaultWriteRequest;
import org.apache.mina.core.write.WriteRequest;
import org.eclipse.scada.protocol.ngp.common.ProtocolConfiguration;
import org.eclipse.scada.protocol.ngp.common.mc.handshake.Handshake;
import org.eclipse.scada.protocol.ngp.common.mc.handshake.HandshakeContext;
import org.eclipse.scada.protocol.ngp.common.mc.handshake.MessageProtocolHandshake;
import org.eclipse.scada.protocol.ngp.common.mc.handshake.SslFeatureHandshake;
import org.eclipse.scada.protocol.ngp.common.mc.handshake.StartSessionHandshake;
import org.eclipse.scada.protocol.ngp.common.mc.handshake.StreamCompressionHandshake;
import org.eclipse.scada.protocol.ngp.common.mc.handshake.TimeoutHandshake;
import org.eclipse.scada.protocol.ngp.common.mc.message.AcceptMessage;
import org.eclipse.scada.protocol.ngp.common.mc.message.CloseMessage;
import org.eclipse.scada.protocol.ngp.common.mc.message.DataMessage;
import org.eclipse.scada.protocol.ngp.common.mc.message.HelloMessage;
import org.eclipse.scada.protocol.ngp.common.mc.message.StartMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageChannelFilter
extends IoFilterAdapter {
    private static final Logger logger = LoggerFactory.getLogger(MessageChannelFilter.class);
    public static final int MAX_TIMEOUT = Integer.getInteger("org.eclipse.scada.protocol.ngp.common.mc.maxTimeoutSeconds", 600) * 1000;
    public static final int MIN_TIMEOUT = Integer.getInteger("org.eclipse.scada.protocol.ngp.common.mc.minTimeoutSeconds", 10) * 1000;
    private final boolean clientMode;
    private final List<Handshake> handshakeHandlers = new LinkedList<Handshake>();
    private Map<String, String> acceptedProperties;

    public MessageChannelFilter(boolean clientMode) {
        this.clientMode = clientMode;
        this.handshakeHandlers.add(new StartSessionHandshake());
        this.handshakeHandlers.add(new SslFeatureHandshake());
        this.handshakeHandlers.add(new TimeoutHandshake());
        this.handshakeHandlers.add(new StreamCompressionHandshake(-1));
        this.handshakeHandlers.add(new MessageProtocolHandshake());
    }

    private List<Handshake> getHanshakeHandlers(ProtocolConfiguration protocolConfiguration) {
        LinkedList<Handshake> result = new LinkedList<Handshake>(this.handshakeHandlers);
        result.addAll(protocolConfiguration.getHandshakeHandlers());
        return result;
    }

    public void sessionOpened(IoFilter.NextFilter nextFilter, IoSession session) throws Exception {
        ProtocolConfiguration configuration = ProtocolConfiguration.fromSession(session);
        session.getConfig().setReaderIdleTime((int)Math.ceil((double)configuration.getHandshakeTimeout() / 1000.0));
        if (this.clientMode) {
            nextFilter.filterWrite(session, (WriteRequest)new DefaultWriteRequest(this.createHelloMessage(session, nextFilter)));
        }
    }

    public void filterWrite(IoFilter.NextFilter nextFilter, IoSession session, WriteRequest writeRequest) throws Exception {
        if (!(writeRequest.getMessage() instanceof DataMessage)) {
            throw new IllegalStateException(String.format("Can only handle messages of type %s (this is: %s)", DataMessage.class, writeRequest.getMessage()));
        }
        super.filterWrite(nextFilter, session, writeRequest);
    }

    public void messageReceived(IoFilter.NextFilter nextFilter, IoSession session, Object message) throws Exception {
        logger.debug("messageReceived - message: {}, session: {}", message, (Object)session);
        boolean opened = MessageChannelFilter.isOpened(session);
        if (message instanceof HelloMessage && !opened && !this.clientMode) {
            Object reply = this.createSession(session, nextFilter, (HelloMessage)message);
            logger.info("Reply to session creation: {}", reply);
            if (reply instanceof AcceptMessage) {
                this.acceptedProperties = Collections.unmodifiableMap(((AcceptMessage)reply).getProperties());
                this.configureSession(session, nextFilter, this.acceptedProperties);
                nextFilter.filterWrite(session, (WriteRequest)new DefaultWriteRequest(reply));
                this.postConfigureSession(session, nextFilter, this.acceptedProperties);
                if (MessageChannelFilter.isOpened(session)) {
                    this.startSession(session, nextFilter);
                }
            } else {
                nextFilter.filterWrite(session, (WriteRequest)new DefaultWriteRequest(reply));
                session.close(false);
            }
            this.dumpFilterChain(session);
            logger.debug("Done handling HelloMessage");
        } else if (message instanceof AcceptMessage && !opened && this.clientMode) {
            this.acceptedProperties = Collections.unmodifiableMap(((AcceptMessage)message).getProperties());
            this.configureSession(session, nextFilter, this.acceptedProperties);
            this.postConfigureSession(session, nextFilter, this.acceptedProperties);
            MessageChannelFilter.markOpened(session);
            this.startSession(session, nextFilter);
            this.dumpFilterChain(session);
        } else if (message instanceof CloseMessage) {
            session.setAttribute((Object)"closeReason.message", (Object)((CloseMessage)message).getMessage());
            session.setAttribute((Object)"closeReason.code", (Object)((CloseMessage)message).getCode());
            session.close(true);
        } else if (message instanceof DataMessage && opened) {
            nextFilter.messageReceived(session, message);
        } else if (message instanceof StartMessage && !opened) {
            logger.debug("Starting session");
            MessageChannelFilter.markOpened(session);
            this.startSession(session, nextFilter);
            this.dumpFilterChain(session);
        } else {
            throw new IllegalStateException(String.format("(opened: %s) Message type: %s", opened, message.getClass()));
        }
    }

    public Map<String, String> getAcceptedProperties() {
        return this.acceptedProperties;
    }

    private void startSession(IoSession session, IoFilter.NextFilter nextFilter) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug("Starting channel: {}", (Object)session);
            this.logProperties("Configure session - acceptedProperties", this.acceptedProperties);
        }
        HandshakeContext context = new HandshakeContext(ProtocolConfiguration.fromSession(session), this.clientMode, session, nextFilter);
        for (Handshake handshake : this.getHanshakeHandlers(ProtocolConfiguration.fromSession(session))) {
            handshake.sessionStarted(context, this.acceptedProperties);
        }
        nextFilter.sessionOpened(session);
    }

    private void dumpFilterChain(IoSession session) {
        if (logger.isInfoEnabled()) {
            logger.info("Filter chain:");
            for (IoFilterChain.Entry entry : session.getFilterChain().getAll()) {
                logger.info("\t{} -> {}", (Object)entry.getName(), (Object)entry.getFilter());
            }
        }
    }

    private Object createHelloMessage(IoSession session, IoFilter.NextFilter nextFilter) {
        HandshakeContext context = new HandshakeContext(ProtocolConfiguration.fromSession(session), this.clientMode, session, nextFilter);
        HashMap<String, String> helloProperties = new HashMap<String, String>();
        for (Handshake handshake : this.getHanshakeHandlers(ProtocolConfiguration.fromSession(session))) {
            handshake.request(context, helloProperties);
        }
        if (logger.isDebugEnabled()) {
            this.logProperties("Request session - helloProperties", helloProperties);
        }
        return new HelloMessage(helloProperties);
    }

    private void configureSession(IoSession session, IoFilter.NextFilter nextFilter, Map<String, String> acceptedProperties) throws Exception {
        HandshakeContext context = new HandshakeContext(ProtocolConfiguration.fromSession(session), this.clientMode, session, nextFilter);
        if (logger.isDebugEnabled()) {
            this.logProperties("Configure session - acceptedProperties", acceptedProperties);
        }
        logger.debug("Running apply");
        for (Handshake handshake : this.getHanshakeHandlers(ProtocolConfiguration.fromSession(session))) {
            handshake.apply(context, acceptedProperties);
        }
    }

    private void postConfigureSession(IoSession session, IoFilter.NextFilter nextFilter, Map<String, String> acceptedProperties) throws Exception {
        HandshakeContext context = new HandshakeContext(ProtocolConfiguration.fromSession(session), this.clientMode, session, nextFilter);
        logger.debug("Running post apply");
        for (Handshake handshake : this.getHanshakeHandlers(ProtocolConfiguration.fromSession(session))) {
            handshake.postApply(context, acceptedProperties);
        }
    }

    private Object createSession(IoSession session, IoFilter.NextFilter nextFilter, HelloMessage message) {
        HashMap<String, String> acceptedProperties = new HashMap<String, String>();
        Map<String, String> helloProperties = message.getProperties();
        ProtocolConfiguration protocolConfiguration = ProtocolConfiguration.fromSession(session);
        HandshakeContext context = new HandshakeContext(protocolConfiguration, this.clientMode, session, nextFilter);
        if (logger.isDebugEnabled()) {
            this.logProperties("Create session - helloProperties", helloProperties);
        }
        try {
            for (Handshake handshake : this.getHanshakeHandlers(ProtocolConfiguration.fromSession(session))) {
                handshake.handshake(context, helloProperties, acceptedProperties);
            }
            if (logger.isDebugEnabled()) {
                this.logProperties("Create session - acceptedProperties", acceptedProperties);
            }
            return new AcceptMessage(acceptedProperties);
        }
        catch (Exception e) {
            return new CloseMessage("Failed handshake on message channel properties: " + e.getMessage(), -2);
        }
    }

    private void logProperties(String string, Map<String, String> properties) {
        StringBuilder sb = new StringBuilder(string);
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            sb.append("\n\t'");
            sb.append(entry.getKey());
            sb.append("' => '");
            sb.append(entry.getValue());
            sb.append('\'');
        }
        logger.debug(sb.toString());
    }

    public static boolean isOpened(IoSession session) {
        return Boolean.TRUE.equals(session.getAttribute((Object)"opened", (Object)Boolean.FALSE));
    }

    public static void markOpened(IoSession session) {
        session.setAttribute((Object)"opened", (Object)Boolean.TRUE);
    }
}

