/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.sec.provider.dummy;

import java.util.Dictionary;
import java.util.Hashtable;
import org.eclipse.scada.sec.AuthenticationService;
import org.eclipse.scada.sec.osgi.AuthorizationManager;
import org.eclipse.scada.sec.provider.dummy.DummyAuthenticationProviderImpl;
import org.eclipse.scada.sec.provider.dummy.DummyAuthorizationProviderImpl;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class Console {
    private final DummyAuthenticationProviderImpl authenticationService;
    private final int priority = Integer.getInteger("org.eclipse.scada.sec.provider.dummy.priority", Integer.MIN_VALUE);
    private final int authenticationPriority = Integer.getInteger("org.eclipse.scada.sec.provider.dummy.authentication.priority", this.priority);
    private final int authorizationPriority = Integer.getInteger("org.eclipse.scada.sec.provider.dummy.authorization.priority", this.priority);
    private BundleContext context;
    private ServiceRegistration<?> authnHandle;
    private ServiceRegistration<?> authzHandle;
    private final DummyAuthorizationProviderImpl authorizationService;

    public Console() {
        this.authenticationService = new DummyAuthenticationProviderImpl();
        this.authorizationService = new DummyAuthorizationProviderImpl();
    }

    public void activate(BundleContext context) {
        this.context = context;
    }

    public synchronized void enableDummyAuthentication() {
        if (this.authnHandle != null) {
            return;
        }
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        ((Dictionary)properties).put("service.description", "A dummy authentication service");
        ((Dictionary)properties).put("service.vendor", "Eclipse SCADA Project");
        ((Dictionary)properties).put("service.ranking", this.authenticationPriority);
        System.out.println(String.format("Injecting dummy authentication service with priority: %s", this.authenticationPriority));
        this.authnHandle = this.context.registerService(AuthenticationService.class, (Object)this.authenticationService, properties);
    }

    public synchronized void disableDummyAuthentication() {
        if (this.authnHandle != null) {
            System.out.println("Removing dummy authentication service");
            this.authnHandle.unregister();
            this.authnHandle = null;
        }
    }

    public synchronized void enableDummyAuthorization() {
        if (this.authzHandle != null) {
            return;
        }
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        ((Dictionary)properties).put("service.description", "A dummy authorization service");
        ((Dictionary)properties).put("service.vendor", "Eclipse SCADA Project");
        ((Dictionary)properties).put("service.ranking", this.authorizationPriority);
        System.out.println(String.format("Injecting dummy authorization service with priority: %s", this.authorizationPriority));
        this.authzHandle = this.context.registerService(AuthorizationManager.class, (Object)this.authorizationService, properties);
    }

    public synchronized void disableDummyAuthorization() {
        if (this.authzHandle != null) {
            System.out.println("Removing dummy authorization service");
            this.authzHandle.unregister();
            this.authzHandle = null;
        }
    }

    public void dispose() {
        this.disableDummyAuthentication();
    }
}

