/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.sec.ui.providers;

import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.scada.sec.callback.CallbackHandler;
import org.eclipse.scada.sec.ui.DisplayCallbackHandler;
import org.eclipse.scada.sec.ui.providers.Key;
import org.eclipse.scada.sec.ui.providers.KeyFactoryManager;
import org.eclipse.scada.sec.ui.providers.KeyInformation;
import org.eclipse.scada.sec.ui.providers.KeyInstanceManager;
import org.eclipse.scada.sec.ui.providers.KeyTreeViewer;
import org.eclipse.scada.sec.ui.providers.Locked;
import org.eclipse.scada.sec.ui.providers.Messages;
import org.eclipse.scada.ui.utils.SelectionHelper;
import org.eclipse.scada.ui.utils.status.StatusHelper;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;

public class KeySelectorDialog
extends TitleAreaDialog {
    private KeyTreeViewer viewer;
    private KeyFactoryManager manager;
    private final String title;
    private final String defaultMessage;
    private Key selectedKey;
    private IObservableValue lockedKeyObs;
    private Button unlockButton;
    private Locked lockable;
    private KeyInformation keyInformation;
    private final Integer maximumTimeout;
    private Spinner spinner;
    private Label spinnerLabel;
    private Button spinnerCheck;

    public KeySelectorDialog(Shell parentShell, String title, String defaultMessage, Integer maximumTimeoutMinutes) {
        super(parentShell);
        this.title = title;
        this.defaultMessage = defaultMessage;
        this.maximumTimeout = maximumTimeoutMinutes;
    }

    protected boolean isResizable() {
        return true;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.getShell().setText(this.title);
        this.setTitle(this.title);
        this.setMessage(this.defaultMessage);
        this.manager = new KeyFactoryManager(SWTObservables.getRealm((Display)parent.getDisplay()));
        this.viewer = new KeyTreeViewer(composite);
        this.viewer.setInput(this.manager);
        this.viewer.getTreeViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                KeySelectorDialog.this.update(event.getSelection());
            }
        });
        this.viewer.getControl().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                KeySelectorDialog.this.handleDispose();
            }
        });
        this.viewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        if (this.isDefaultAllowed()) {
            Composite spinnerWrapper = new Composite(composite, 0);
            spinnerWrapper.setLayout((Layout)new GridLayout(3, false));
            this.spinnerCheck = new Button(spinnerWrapper, 32);
            this.spinnerCheck.setText(Messages.KeySelectorDialog_Remember_Text);
            this.spinnerCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    KeySelectorDialog.this.updateSpinnerSelection();
                }
            });
            this.spinnerCheck.setLayoutData((Object)new GridData(4, 0x1000000, false, true));
            this.spinner = new Spinner(spinnerWrapper, 2048);
            this.spinner.setMinimum(0);
            this.spinner.setMaximum(this.maximumTimeout.intValue());
            this.spinner.setLayoutData((Object)new GridData(4, 0x1000000, false, true));
            this.spinnerLabel = new Label(spinnerWrapper, 0);
            this.spinnerLabel.setText(Messages.KeySelectorDialog_RememberLabel_Text_Minutes);
            this.spinnerLabel.setLayoutData((Object)new GridData(4, 0x1000000, false, true));
            this.spinner.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    KeySelectorDialog.this.updateSpinnerSelection();
                }
            });
        }
        this.updateSpinnerSelection();
        return composite;
    }

    private boolean isDefaultAllowed() {
        if (this.maximumTimeout == null) {
            return false;
        }
        return this.maximumTimeout > 0;
    }

    protected void updateSpinnerSelection() {
        this.spinner.setEnabled(this.spinnerCheck.getSelection());
        int selection = this.spinner.getSelection();
        if (selection <= 0) {
            this.spinnerLabel.setText(Messages.KeySelectorDialog_RememberLabel_Text_Forever);
        } else if (selection == 1) {
            this.spinnerLabel.setText(Messages.KeySelectorDialog_RememberLabel_Text_Minute);
        } else {
            this.spinnerLabel.setText(Messages.KeySelectorDialog_RememberLabel_Text_Minutes);
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.unlockButton = this.createButton(parent, 256, Messages.KeySelectorDialog_ButtonUnlock_Text, false);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 256) {
            this.performUnlock(this.lockable);
        }
        super.buttonPressed(buttonId);
    }

    private void performUnlock(Locked locked) {
        try {
            locked.unlock((CallbackHandler)new DisplayCallbackHandler(this.getShell(), Messages.KeySelectorDialog_Callback_Title, Messages.KeySelectorDialog_Callback_Description));
        }
        catch (Exception e) {
            ErrorDialog.openError((Shell)this.getShell(), (String)Messages.KeySelectorDialog_Error_Title, (String)Messages.KeySelectorDialog_Error_Text, (IStatus)StatusHelper.convertStatus((String)"org.eclipse.scada.sec.ui.providers", (Throwable)e));
        }
    }

    protected Control createButtonBar(Composite parent) {
        Control result = super.createButtonBar(parent);
        this.update((ISelection)StructuredSelection.EMPTY);
        return result;
    }

    protected void update(ISelection selection) {
        if (this.lockedKeyObs != null) {
            this.lockedKeyObs.dispose();
        }
        this.selectedKey = (Key)SelectionHelper.first((ISelection)selection, Key.class);
        this.lockable = (Locked)SelectionHelper.first((ISelection)selection, Locked.class);
        if (this.lockable != null) {
            this.lockedKeyObs = BeansObservables.observeValue((Object)this.lockable, (String)"locked");
            this.lockedKeyObs.addValueChangeListener((IValueChangeListener)new ButtonUpdater());
        }
        this.updateButtons();
    }

    protected void updateButtons() {
        Button ok = this.getButton(0);
        if (ok != null) {
            ok.setEnabled(this.hasKeySelected());
        }
        this.unlockButton.setEnabled(this.lockable != null && this.lockable.isLocked());
    }

    private boolean hasKeySelected() {
        return this.selectedKey != null && !this.selectedKey.isLocked();
    }

    protected void handleDispose() {
        this.viewer.dispose();
        this.manager.dispose();
    }

    public KeyInformation getKeyInformation() {
        return this.keyInformation;
    }

    protected void okPressed() {
        this.keyInformation = this.selectedKey != null ? new KeyInformation(this.selectedKey.getName(), this.selectedKey.getKey(), this.selectedKey.getCertificate()) : null;
        if (this.spinner != null && this.spinnerCheck != null && this.spinnerCheck.getSelection()) {
            KeyInstanceManager.getInstance(this.getShell().getDisplay()).setDefaultKey(this.keyInformation, this.spinner.getSelection() * 60 * 1000);
        }
        super.okPressed();
    }

    private final class ButtonUpdater
    implements IValueChangeListener {
        private ButtonUpdater() {
        }

        public void handleValueChange(ValueChangeEvent event) {
            KeySelectorDialog.this.updateButtons();
        }
    }
}

