/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ae.monitor.datasource;

import com.google.common.collect.Interner;
import java.util.Map;
import java.util.concurrent.Executor;
import org.eclipse.scada.ae.event.EventProcessor;
import org.eclipse.scada.ae.monitor.datasource.AbstractVariantMonitor;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.da.client.DataItemValue;
import org.eclipse.scada.da.master.MasterItem;
import org.eclipse.scada.utils.osgi.pool.ObjectPoolTracker;
import org.osgi.framework.BundleContext;

public abstract class AbstractNumericMonitor
extends AbstractVariantMonitor {
    public AbstractNumericMonitor(BundleContext context, Executor executor, Interner<String> stringInterner, ObjectPoolTracker<MasterItem> poolTracker, EventProcessor eventProcessor, String id, String factoryId, String prefix, String defaultMonitorType) {
        super(context, executor, stringInterner, poolTracker, eventProcessor, id, factoryId, prefix, defaultMonitorType);
    }

    protected abstract void performNumericUpdate(DataItemValue.Builder var1, Number var2);

    @Override
    protected void performValueUpdate(Map<String, Object> context, DataItemValue.Builder builder, Variant value) {
        if (value.isDouble()) {
            this.performNumericUpdate(builder, value.asDouble(null));
        } else if (value.isInteger()) {
            this.performNumericUpdate(builder, value.asInteger(null));
        } else if (value.isLong()) {
            this.performNumericUpdate(builder, value.asInteger(null));
        } else if (value.isBoolean()) {
            this.performNumericUpdate(builder, value.asBoolean(null) != false ? 1 : 0);
        } else {
            String str = value.asString("");
            try {
                double d = Double.parseDouble(str);
                this.performNumericUpdate(builder, d);
            }
            catch (NumberFormatException numberFormatException) {
                this.setUnsafe();
            }
        }
    }
}

