/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ae.protocol.ngp.codec.impl;

import java.util.List;
import org.apache.mina.core.buffer.IoBuffer;
import org.eclipse.scada.ae.data.EventInformation;
import org.eclipse.scada.ae.protocol.ngp.codec.Structures;
import org.eclipse.scada.core.ngp.common.codec.osbp.BinaryContext;
import org.eclipse.scada.core.ngp.common.codec.osbp.BinaryMessageCodec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventPoolDataUpdate
implements BinaryMessageCodec {
    private static final Logger logger = LoggerFactory.getLogger(EventPoolDataUpdate.class);
    public static final int MESSAGE_CODE = 8452;

    public int getMessageCode() {
        return 8452;
    }

    public Class<?> getMessageClass() {
        return org.eclipse.scada.ae.data.message.EventPoolDataUpdate.class;
    }

    public org.eclipse.scada.ae.data.message.EventPoolDataUpdate decodeMessage(BinaryContext _context, IoBuffer _data) throws Exception {
        int messageCode = _data.getInt();
        if (messageCode != 8452) {
            throw new IllegalStateException(String.format("Expected messageCode %s but found %s", 8452, messageCode));
        }
        int numberOfFields = _data.get();
        String eventPoolId = null;
        List<EventInformation> addedEvents = null;
        logger.trace("Decoding {} fields", (Object)((byte)numberOfFields));
        int i = 0;
        while (i < numberOfFields) {
            byte fieldNumber = _data.get();
            switch (fieldNumber) {
                case 1: {
                    eventPoolId = _context.decodeString(_data);
                    break;
                }
                case 2: {
                    addedEvents = Structures.decodeListEventInformation(_context, _data, true);
                    break;
                }
                default: {
                    logger.warn("Received unknown field number: {}", (Object)fieldNumber);
                }
            }
            ++i;
        }
        return new org.eclipse.scada.ae.data.message.EventPoolDataUpdate(eventPoolId, addedEvents);
    }

    public IoBuffer encodeMessage(BinaryContext context, Object objectMessage) throws Exception {
        org.eclipse.scada.ae.data.message.EventPoolDataUpdate value = (org.eclipse.scada.ae.data.message.EventPoolDataUpdate)objectMessage;
        IoBuffer data = IoBuffer.allocate((int)64);
        data.setAutoExpand(true);
        data.putInt(8452);
        data.put((byte)2);
        context.encodeString(data, (byte)1, value.getEventPoolId());
        Structures.encodeCollectionEventInformation(context, data, (byte)2, value.getAddedEvents());
        data.flip();
        return data;
    }
}

