/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.world.lib.oscar;

import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.scada.configuration.world.World;
import org.eclipse.scada.configuration.world.lib.oscar.AlarmsAndEventsProcessor;
import org.eclipse.scada.configuration.world.lib.oscar.AlarmsEventsModuleProcessor;
import org.eclipse.scada.configuration.world.lib.oscar.AverageProcessor;
import org.eclipse.scada.configuration.world.lib.oscar.BlockingProcessor;
import org.eclipse.scada.configuration.world.lib.oscar.BufferProcessor;
import org.eclipse.scada.configuration.world.lib.oscar.DataMapperProcessor;
import org.eclipse.scada.configuration.world.lib.oscar.EquinoxApplicationProcessor;
import org.eclipse.scada.configuration.world.lib.oscar.ItemExportProcessor;
import org.eclipse.scada.configuration.world.lib.oscar.ItemProcessor;
import org.eclipse.scada.configuration.world.lib.oscar.MarkerGroupProcessor;
import org.eclipse.scada.configuration.world.lib.oscar.MasterHandlerPriorities;
import org.eclipse.scada.configuration.world.lib.oscar.OscarContext;
import org.eclipse.scada.configuration.world.osgi.EquinoxApplication;
import org.eclipse.scada.configuration.world.osgi.MasterServer;

public class MasterServerProcessor
extends EquinoxApplicationProcessor {
    private final MasterServer app;
    private final MasterHandlerPriorities priorities;

    public MasterServerProcessor(World world, MasterServer app) {
        super((EquinoxApplication)app);
        this.priorities = new MasterHandlerPriorities(world);
        this.app = app;
    }

    @Override
    protected void processForContext(OscarContext ctx, IFolder output, IProgressMonitor monitor) {
        new AlarmsEventsModuleProcessor(this.app, ctx).process((IProgressMonitor)new SubProgressMonitor(monitor, 1));
        new ItemProcessor(this.app, ctx, this.priorities).process();
        new ItemExportProcessor((EquinoxApplication)this.app, ctx).process();
        new MarkerGroupProcessor(this.app, ctx, this.priorities).process();
        new AlarmsAndEventsProcessor(this.app, ctx).process();
        new DataMapperProcessor(this.app, ctx).process();
        new AverageProcessor(this.app, ctx).process();
        new BufferProcessor(this.app, ctx).process();
        new BlockingProcessor((EquinoxApplication)this.app, ctx).process();
    }

    @Override
    protected void customizeContext(OscarContext context) {
        super.customizeContext(context);
        context.addIgnoreFields("org.eclipse.scada.da.manual", "value", "user", "reason", "timestamp");
        context.addIgnoreFields("org.eclipse.scada.da.master.common.block", "note", "active", "user", "timestamp");
        context.addIgnoreFields("org.eclipse.scada.ae.monitor.level", "preset", "active");
        context.addIgnoreFields("org.eclipse.scada.ae.monitor.list", "active");
        context.addIgnoreFields("org.eclipse.scada.ae.monitor.bit", "active", "reference");
        context.addIgnoreFields("org.eclipse.scada.da.master.common.marker", "active");
        context.addIgnoreFields("org.eclipse.scada.da.scale.input", "active", "factor");
    }
}

