/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.world.lib.validator.handler;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.scada.configuration.world.lib.validator.DataSourceDescriptor;
import org.eclipse.scada.configuration.world.lib.validator.handler.LoopHandler;
import org.eclipse.scada.configuration.world.lib.validator.handler.NoOpHandler;

public class MultiSourceAttributeHandler
extends NoOpHandler
implements LoopHandler {
    private final String[] attributePrefix;

    public MultiSourceAttributeHandler(String ... attributePrefix) {
        this.attributePrefix = attributePrefix;
    }

    @Override
    public Set<DataSourceDescriptor> getNode(String configurationId, Map<String, String> parameters) {
        DataSourceDescriptor desc = this.createNode(configurationId, parameters);
        return new HashSet<DataSourceDescriptor>(Arrays.asList(desc));
    }

    protected DataSourceDescriptor createNode(String configurationId, Map<String, String> parameters) {
        DataSourceDescriptor desc = new DataSourceDescriptor("datasource", configurationId);
        String[] stringArray = this.attributePrefix;
        int n = this.attributePrefix.length;
        int n2 = 0;
        while (n2 < n) {
            String prefix = stringArray[n2];
            for (Map.Entry<String, String> entry : parameters.entrySet()) {
                if (!entry.getKey().startsWith(prefix) || !(entry.getValue() instanceof String) || entry.getValue().isEmpty()) continue;
                desc.addReference("datasource", entry.getValue());
            }
            ++n2;
        }
        return desc;
    }

    @Override
    public boolean providesDescriptors() {
        return true;
    }
}

