/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.component.parser.factory.internal;

import java.util.HashMap;
import org.eclipse.scada.base.extractor.convert.ValueConverter;
import org.eclipse.scada.base.extractor.extract.pattern.FieldSpec;
import org.eclipse.scada.base.extractor.extract.pattern.MainFieldSpec;
import org.eclipse.scada.base.extractor.extract.pattern.NumberFieldSpec;
import org.eclipse.scada.base.extractor.extract.pattern.StringFieldSpec;
import org.eclipse.scada.base.extractor.extract.pattern.ValueFieldDescriptor;
import org.eclipse.scada.core.VariantType;
import org.eclipse.scada.da.server.component.parser.factory.configuration.AttributeValue;
import org.eclipse.scada.da.server.component.parser.factory.configuration.Field;
import org.eclipse.scada.da.server.component.parser.factory.configuration.MainGroupField;
import org.eclipse.scada.da.server.component.parser.factory.configuration.NumericGroupField;
import org.eclipse.scada.da.server.component.parser.factory.configuration.StringGroupField;
import org.eclipse.scada.da.server.component.parser.factory.configuration.ValueConverterDefinition;
import org.eclipse.scada.da.server.component.parser.factory.configuration.ValueDescriptor;

public final class Descriptors {
    private Descriptors() {
    }

    public static ValueConverter createConverter(ValueConverterDefinition def) {
        if (def == null) {
            return null;
        }
        return def.createConverter();
    }

    public static ValueFieldDescriptor convert(ValueDescriptor descriptor) {
        if (descriptor == null) {
            return null;
        }
        HashMap<String, FieldSpec> attributes = new HashMap<String, FieldSpec>();
        for (AttributeValue attr : descriptor.getAttributes()) {
            attributes.put(attr.getName(), Descriptors.convert(attr.getField()));
        }
        return new ValueFieldDescriptor(Descriptors.convert(descriptor.getPrimaryValue()), attributes);
    }

    private static FieldSpec convert(Field field) {
        if (field == null) {
            return null;
        }
        if (field instanceof MainGroupField) {
            return new MainFieldSpec(Descriptors.convert(field.getType()));
        }
        if (field instanceof NumericGroupField) {
            return new NumberFieldSpec(((NumericGroupField)field).getGroupNumber(), Descriptors.convert(field.getType()));
        }
        if (field instanceof StringGroupField) {
            return new StringFieldSpec(((StringGroupField)field).getGroupName(), Descriptors.convert(field.getType()));
        }
        throw new RuntimeException(String.format("Unsupported field type: %s", field.getClass().getName()));
    }

    private static VariantType convert(org.eclipse.scada.da.server.component.parser.factory.configuration.VariantType type) {
        if (type == null || type == org.eclipse.scada.da.server.component.parser.factory.configuration.VariantType.DEFAULT) {
            return null;
        }
        return VariantType.valueOf((String)type.name());
    }
}

