/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.dave;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.eclipse.scada.ca.ConfigurationFactory;
import org.eclipse.scada.ca.common.factory.BeanConfigurationFactory;
import org.eclipse.scada.da.server.common.DataItem;
import org.eclipse.scada.da.server.dave.BlockConfiguration;
import org.eclipse.scada.da.server.dave.factory.ConfigurationFactoryImpl;
import org.eclipse.scada.utils.concurrent.NamedThreadFactory;
import org.eclipse.scada.utils.osgi.pool.ObjectPoolHelper;
import org.eclipse.scada.utils.osgi.pool.ObjectPoolImpl;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class Activator
implements BundleActivator {
    private ConfigurationFactoryImpl service;
    private BeanConfigurationFactory blockFactory;
    private ExecutorService executor;
    private ObjectPoolImpl<DataItem> itemPool;
    private ServiceRegistration<?> itemPoolHandle;

    public void start(BundleContext context) throws Exception {
        this.itemPool = new ObjectPoolImpl();
        this.itemPoolHandle = ObjectPoolHelper.registerObjectPool((BundleContext)context, this.itemPool, DataItem.class);
        this.executor = Executors.newSingleThreadExecutor((ThreadFactory)new NamedThreadFactory(context.getBundle().getSymbolicName()));
        this.service = new ConfigurationFactoryImpl(context);
        Hashtable<String, String> properties = new Hashtable<String, String>();
        ((Dictionary)properties).put("factoryId", "org.eclipse.scada.da.server.dave.device");
        context.registerService(ConfigurationFactory.class.getName(), (Object)this.service, properties);
        properties = new Hashtable();
        ((Dictionary)properties).put("factoryId", "org.eclipse.scada.da.server.dave.block");
        this.blockFactory = new BeanConfigurationFactory(context, BlockConfiguration.class);
        context.registerService(ConfigurationFactory.class.getName(), (Object)this.blockFactory, properties);
    }

    public void stop(BundleContext context) throws Exception {
        this.itemPoolHandle.unregister();
        this.itemPool.dispose();
        this.blockFactory.dispose();
        this.service.dispose();
        this.executor.shutdown();
        this.executor = null;
    }
}

