/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.dave;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.scada.da.server.common.memory.AbstractRequestBlock;
import org.eclipse.scada.da.server.dave.BlockConfiguration;
import org.eclipse.scada.da.server.dave.DaveDevice;
import org.eclipse.scada.da.server.dave.DaveRequestBlock;
import org.eclipse.scada.protocol.dave.DaveReadRequest;
import org.eclipse.scada.utils.osgi.FilterUtil;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DaveBlockConfigurator {
    private static final Logger logger = LoggerFactory.getLogger(DaveBlockConfigurator.class);
    private final DaveDevice device;
    private final BundleContext context;
    private ServiceTracker<?, ?> tracker;
    private final Map<ServiceReference<?>, String> blocks = new HashMap();

    public DaveBlockConfigurator(DaveDevice device, final BundleContext context) {
        this.device = device;
        this.context = context;
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("daveDevice", device.getId());
        try {
            Filter filter = FilterUtil.createAndFilter((String)BlockConfiguration.class.getName(), parameters);
            this.tracker = new ServiceTracker(context, filter, (ServiceTrackerCustomizer)new ServiceTrackerCustomizer<Object, Object>(){

                public void removedService(ServiceReference<Object> reference, Object service) {
                    if (service instanceof BlockConfiguration && DaveBlockConfigurator.this.removeBlock(reference, (BlockConfiguration)service)) {
                        context.ungetService(reference);
                    }
                }

                public void modifiedService(ServiceReference<Object> reference, Object service) {
                    DaveBlockConfigurator.this.modifyBlock(reference, (BlockConfiguration)service);
                }

                public Object addingService(ServiceReference<Object> reference) {
                    Object o = DaveBlockConfigurator.this.context.getService(reference);
                    try {
                        DaveBlockConfigurator.this.addOrReplaceBlock(reference, (BlockConfiguration)o);
                        return o;
                    }
                    catch (Throwable e) {
                        logger.warn("Failed to add block", e);
                        return o;
                    }
                }
            });
        }
        catch (Exception e) {
            logger.warn("Failed to configure", (Throwable)e);
        }
        if (this.tracker != null) {
            this.tracker.open();
        }
    }

    protected void modifyBlock(ServiceReference<?> reference, BlockConfiguration service) {
        logger.info("Modify block: {}", reference);
        this.addOrReplaceBlock(reference, service);
    }

    protected boolean removeBlock(ServiceReference<?> reference, BlockConfiguration block) {
        String oldBlock = this.blocks.remove(reference);
        if (oldBlock != null) {
            this.device.removeBlock(oldBlock);
            return true;
        }
        return false;
    }

    protected void addOrReplaceBlock(ServiceReference<?> reference, BlockConfiguration block) {
        logger.info(String.format("Adding or replace block - ref: %s, block: %s", reference, block));
        String oldBlock = this.blocks.put(reference, block.getId());
        if (oldBlock != null) {
            logger.info("Replacing exisiting block");
            this.device.removeBlock(oldBlock);
        }
        AbstractRequestBlock deviceBlock = this.makeBlock(block);
        try {
            this.device.addBlock(block.getId(), deviceBlock);
        }
        catch (Exception e) {
            logger.warn("Failed to add block", (Throwable)e);
            deviceBlock.dispose();
        }
    }

    private AbstractRequestBlock makeBlock(BlockConfiguration block) {
        logger.debug("Make new block: {}", (Object)block);
        DaveReadRequest.Request request = new DaveReadRequest.Request((byte)block.getArea(), (short)block.getBlock(), (short)block.getStart(), (short)block.getCount());
        DaveRequestBlock deviceBlock = new DaveRequestBlock(block.getId(), block.getName(), block.getType(), this.device, this.context, request, block.isEnableStatistics(), block.getPeriod());
        return deviceBlock;
    }

    public void dispose() {
        if (this.tracker != null) {
            this.tracker.close();
        }
    }
}

