/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.dave;

import java.util.Iterator;
import java.util.concurrent.Executor;
import org.eclipse.scada.da.server.common.memory.AbstractRequestBlock;
import org.eclipse.scada.da.server.dave.DaveDevice;
import org.eclipse.scada.protocol.dave.DaveReadRequest;
import org.eclipse.scada.protocol.dave.DaveReadResult;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DaveRequestBlock
extends AbstractRequestBlock {
    private static final Logger logger = LoggerFactory.getLogger(DaveRequestBlock.class);
    private final DaveReadRequest.Request request;
    private final DaveDevice device;

    public DaveRequestBlock(String id, String name, String mainTypeName, DaveDevice device, BundleContext context, DaveReadRequest.Request request, boolean enableStatistics, long period) {
        super(context, (Executor)device.getExecutor(), mainTypeName, device.getVarItemId(name), device.getItemId(id), enableStatistics, period, (int)request.getCount(), 0L, true);
        this.device = device;
        this.request = request;
        this.initialize();
    }

    public long getPollRequestTimeout() {
        return 0L;
    }

    public DaveReadRequest.Request getRequest() {
        return this.request;
    }

    public synchronized void handleResponse(DaveReadResult.Result response) {
        if (response.isError()) {
            this.handleError(response.getError().shortValue());
        } else {
            this.handleData(response.getData());
        }
    }

    public void handleTimeout() {
    }

    public String toString() {
        return String.format("[Request - %s]", this.request);
    }

    public boolean handleMessage(Object message) {
        if (message instanceof DaveReadResult) {
            Iterator iterator = ((DaveReadResult)message).getResult().iterator();
            if (iterator.hasNext()) {
                DaveReadResult.Result result = (DaveReadResult.Result)iterator.next();
                this.handleResponse(result);
                return true;
            }
        } else {
            logger.warn("Got wrong message as reply: {}", message);
        }
        return false;
    }

    public Object createPollRequest() {
        DaveReadRequest request = new DaveReadRequest();
        request.addRequest(this.request);
        return request;
    }

    public int getStartAddress() {
        return this.request.getStart();
    }

    private int toGlobalAddress(int address) {
        return address + this.request.getStart();
    }

    public void writeBit(int address, int subIndex, boolean value) {
        this.device.writeBit(this, this.toGlobalAddress(address), subIndex, value);
    }

    public void writeData(int blockAddress, byte[] data) {
        this.device.writeData(this, this.toGlobalAddress(blockAddress), data);
    }
}

