/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.jdbc;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.eclipse.scada.da.server.jdbc.ConnectionFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.jdbc.DataSourceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultConnectionFactory
implements ConnectionFactory {
    private static final Logger logger = LoggerFactory.getLogger(DefaultConnectionFactory.class);
    private final BundleContext bundleContext;
    private final Set<String> forNameSet = new HashSet<String>();

    public DefaultConnectionFactory(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Connection createConnection(String connectionClass, String uri, Properties properties, Integer timeout) throws Exception {
        if (this.bundleContext == null && !this.forNameSet.contains(connectionClass)) {
            logger.info("Try loading driver using Class.forName()");
            this.forNameSet.add(connectionClass);
            try {
                if (connectionClass != null) {
                    Class.forName(connectionClass);
                }
            }
            catch (Throwable e) {
                logger.error("Failed to initialize connection", e);
            }
        }
        if (timeout != null) {
            DriverManager.setLoginTimeout(timeout / 1000);
        }
        try {
            logger.debug("Try to create a connection using plain JDBC");
            return DriverManager.getConnection(uri, properties);
        }
        catch (SQLException e) {
            logger.info("Failed to get connection", (Throwable)e);
            try {
                if (this.bundleContext == null) throw new IllegalStateException(String.format("Unable for find a suitable driver for '%s'", uri));
                logger.debug("Try to create a connection using OSGi - class: {}", (Object)connectionClass);
                Collection refs = this.bundleContext.getServiceReferences(DataSourceFactory.class, "(osgi.jdbc.driver.class=" + connectionClass + ")");
                if (refs == null) throw new IllegalStateException(String.format("Unable for find a suitable driver for '%s'", uri));
                for (ServiceReference ref : refs) {
                    logger.debug("Checking service ref: {}", (Object)ref);
                    DataSourceFactory service = (DataSourceFactory)this.bundleContext.getService(ref);
                    try {
                        Driver driver = service.createDriver(null);
                        if (!driver.acceptsURL(uri)) continue;
                        Properties p = new Properties();
                        p.put("url", uri);
                        Connection connection = driver.connect(uri, p);
                        return connection;
                    }
                    finally {
                        this.bundleContext.ungetService(ref);
                        throw new IllegalStateException(String.format("Unable for find a suitable driver for '%s'", uri));
                    }
                }
            }
            catch (Exception e2) {
                logger.info("Failed to load driver using OSGi", (Throwable)e2);
            }
        }
        throw new IllegalStateException(String.format("Unable for find a suitable driver for '%s'", uri));
    }
}

