/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.hd.server.storage.hds;

import java.io.File;
import java.io.FileInputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ScheduledExecutorService;
import org.eclipse.scada.utils.concurrent.ScheduledExportedExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractStorageManager {
    private static final Logger logger = LoggerFactory.getLogger(AbstractStorageManager.class);
    protected final ScheduledExecutorService queryExecutor;
    protected final File base;

    public AbstractStorageManager(File base) {
        this.base = base;
        this.queryExecutor = new ScheduledExportedExecutorService("HDSQuery/" + base, Integer.getInteger("org.eclipse.scada.hd.server.storage.hds.coreQueryThread", 1).intValue());
    }

    public File getBase() {
        return this.base;
    }

    public void dispose() {
        this.queryExecutor.shutdown();
    }

    protected Map<String, File> findStorages() {
        logger.info("Scanning for storages: {}", (Object)this.base);
        if (!this.base.exists()) {
            logger.info("The storage base does not exists: {}", (Object)this.base);
            this.handleBaseNotFound();
        }
        HashMap<String, File> storages = new HashMap<String, File>();
        File[] fileArray = this.base.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            String id;
            File file = fileArray[n2];
            logger.debug("Found entry - file: {}, dir: {}", (Object)file, (Object)file.isDirectory());
            if (file.isDirectory() && (id = this.probe(file)) != null) {
                if (!storages.containsKey(id)) {
                    storages.put(id, file);
                } else {
                    logger.error("Duplicate data store id ({}) found in {}", (Object)id, (Object)file);
                }
            }
            ++n2;
        }
        return storages;
    }

    protected void handleBaseNotFound() {
        throw new IllegalStateException(String.format("The storage base directory does not exists: %s", this.base));
    }

    protected String probe(File file) {
        logger.debug("Probing: {}", (Object)file);
        File settingsFile = new File(file, "settings.xml");
        if (!settingsFile.isFile()) {
            logger.debug("No settings file: {}", (Object)settingsFile);
            return null;
        }
        if (!settingsFile.canRead()) {
            logger.debug("Settings file not readable: {}", (Object)settingsFile);
            return null;
        }
        Properties p = new Properties();
        try {
            p.loadFromXML(new FileInputStream(settingsFile));
            logger.debug("Loaded properties: {}", (Object)p);
            return p.getProperty("id");
        }
        catch (Exception e) {
            logger.warn(String.format("Failed to load settings: %s", settingsFile), (Throwable)e);
            return null;
        }
    }

    protected void checkValid() {
        if (!this.base.isDirectory()) {
            throw new IllegalStateException(String.format("'%s' is not a valid base directory (not a directory)", this.base));
        }
    }
}

