/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.sec.auth.logon;

import java.util.concurrent.Future;
import org.eclipse.scada.sec.AuthenticationImplementation;
import org.eclipse.scada.sec.AuthorizationResult;
import org.eclipse.scada.sec.UserInformation;
import org.eclipse.scada.sec.authz.AuthorizationContext;
import org.eclipse.scada.sec.authz.AuthorizationRule;
import org.eclipse.scada.utils.concurrent.CallingFuture;
import org.eclipse.scada.utils.concurrent.InstantFuture;
import org.eclipse.scada.utils.concurrent.NotifyFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AuthorizationRuleImpl
implements AuthorizationRule {
    private static final Logger logger = LoggerFactory.getLogger(AuthorizationRuleImpl.class);
    private final AuthenticationImplementation authenticator;

    public AuthorizationRuleImpl(AuthenticationImplementation authenticator) {
        this.authenticator = authenticator;
    }

    public void dispose() {
    }

    public NotifyFuture<AuthorizationResult> authorize(final AuthorizationContext context) {
        logger.debug("Authorizing - request: {}", (Object)context.getRequest());
        UserInformation userInformation = context.getRequest().getUserInformation();
        if (userInformation != null && !userInformation.isAnonymous()) {
            return new InstantFuture(null);
        }
        NotifyFuture future = this.authenticator.authenticate(context.getCallbackHandler());
        return new CallingFuture<UserInformation, AuthorizationResult>(future){

            public AuthorizationResult call(Future<UserInformation> future) throws Exception {
                AuthorizationResult result = AuthorizationRuleImpl.this.process(context, future);
                logger.debug("Result of authorize call: {}", (Object)result);
                return result;
            }
        };
    }

    protected AuthorizationResult process(AuthorizationContext context, Future<UserInformation> future) throws Exception {
        try {
            context.changeUserInformation(future.get());
            return null;
        }
        catch (Exception e) {
            logger.debug("Failed to authorize logon", (Throwable)e);
            return AuthorizationResult.createReject((Throwable)e);
        }
    }
}

