/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.generator.component.app;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.scada.configuration.component.ComponentWorld;
import org.eclipse.scada.configuration.component.MarkerConfiguration;
import org.eclipse.scada.configuration.generator.GeneratorContext;
import org.eclipse.scada.configuration.generator.component.app.MasterApplicationProcessor;
import org.eclipse.scada.configuration.infrastructure.lib.WorldGenerator;
import org.eclipse.scada.configuration.world.osgi.Item;
import org.eclipse.scada.configuration.world.osgi.MarkerGroup;
import org.eclipse.scada.configuration.world.osgi.MasterServer;
import org.eclipse.scada.configuration.world.osgi.OsgiFactory;
import org.eclipse.scada.utils.str.StringHelper;

public class MarkerGroupGeneratorProcessor
extends MasterApplicationProcessor {
    public MarkerGroupGeneratorProcessor() {
    }

    public MarkerGroupGeneratorProcessor(ComponentWorld system, WorldGenerator world) {
        super(system, world);
    }

    @Override
    public void processContext(GeneratorContext.MasterContext masterContext, IProgressMonitor monitor) {
        MasterServer app = masterContext.getImplementation();
        MarkerConfiguration cfg = this.findDefaultConfiguration(MarkerConfiguration.class);
        if (cfg == null) {
            return;
        }
        HashMap<String, List<Item>> itemGroups = new HashMap<String, List<Item>>();
        for (Item item : app.getItems()) {
            if (item.getInformation() == null) continue;
            this.buildMarker(item, itemGroups, new LinkedList<String>((Collection<String>)item.getInformation().getHierarchy()));
        }
        if (app.getMarkers() == null) {
            app.setMarkers(OsgiFactory.eINSTANCE.createMarkers());
        }
        for (Map.Entry entry : itemGroups.entrySet()) {
            MarkerGroup markerGroup = OsgiFactory.eINSTANCE.createMarkerGroup();
            app.getMarkers().getMarkerGroups().add((Object)markerGroup);
            markerGroup.setName((String)entry.getKey());
            markerGroup.getItems().addAll((Collection)entry.getValue());
            markerGroup.getMarkers().addAll(EcoreUtil.copyAll((Collection)cfg.getMarkers()));
        }
    }

    private void buildMarker(Item item, Map<String, List<Item>> itemGroups, LinkedList<String> hierarchy) {
        if (hierarchy.isEmpty()) {
            return;
        }
        String id = StringHelper.join(hierarchy, (String)"_");
        List<Item> items = itemGroups.get(id);
        if (items == null) {
            items = new LinkedList<Item>();
            itemGroups.put(id, items);
        }
        items.add(item);
    }
}

