/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.world.lib.deployment;

import com.google.common.io.CharStreams;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.scada.utils.pkg.deb.ContentProvider;
import org.eclipse.scada.utils.pkg.deb.StaticContentProvider;
import org.eclipse.scada.utils.str.StringReplacer;

public class Contents {
    private static final Pattern PATTERN = Pattern.compile("\\$\\$(.*?)\\$\\$");

    public static ContentProvider createContent(InputStream resource, Map<String, String> replacements, Pattern pattern) throws IOException {
        try {
            String str = CharStreams.toString((Readable)new InputStreamReader(resource, StandardCharsets.UTF_8));
            str = StringReplacer.replace((String)str, (StringReplacer.ReplaceSource)StringReplacer.newSource(replacements), (Pattern)pattern);
            StaticContentProvider staticContentProvider = new StaticContentProvider(str);
            return staticContentProvider;
        }
        finally {
            resource.close();
        }
    }

    public static ContentProvider createContent(InputStream resource, Map<String, String> replacements) throws IOException {
        return Contents.createContent(resource, replacements, PATTERN);
    }
}

