/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.world.lib.deployment;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.UserDefinedFileAttributeView;

public final class Executables {
    private static final Charset CHARSET = Charset.defaultCharset();
    private static final String ATTR_EXECUTE = "user.execute";
    private static byte[] marker = "true".getBytes(CHARSET);

    private Executables() {
    }

    public static void setExecutable(File file, boolean state) throws IOException {
        Executables.setExecutable(file.toPath(), state);
    }

    public static boolean getExecutable(File file) throws IOException {
        return Executables.getExecutable(file.toPath());
    }

    public static void setExecutable(Path path, boolean state) throws IOException {
        UserDefinedFileAttributeView ua = Files.getFileAttributeView(path, UserDefinedFileAttributeView.class, new LinkOption[0]);
        if (state) {
            ua.write(ATTR_EXECUTE, ByteBuffer.wrap(marker));
        } else {
            ua.delete(ATTR_EXECUTE);
        }
    }

    public static boolean getExecutable(Path path) throws IOException {
        UserDefinedFileAttributeView ua = Files.getFileAttributeView(path, UserDefinedFileAttributeView.class, new LinkOption[0]);
        if (!ua.list().contains(ATTR_EXECUTE)) {
            return false;
        }
        ByteBuffer buf = ByteBuffer.allocate(ua.size(ATTR_EXECUTE));
        ua.read(ATTR_EXECUTE, buf);
        buf.flip();
        return Boolean.parseBoolean(CHARSET.decode(buf).toString());
    }

    public static void setAllExecutable(Path directory, final boolean state) throws IOException {
        Files.walkFileTree(directory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                if (Files.isRegularFile(file, LinkOption.NOFOLLOW_LINKS)) {
                    Executables.setExecutable(file, state);
                }
                return super.visitFile(file, attrs);
            }
        });
    }
}

