/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.world.lib.deployment;

import java.io.IOException;
import java.net.URI;
import java.nio.file.FileVisitResult;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.scada.configuration.world.lib.deployment.DeploymentContext;
import org.eclipse.scada.configuration.world.lib.deployment.Executables;
import org.eclipse.scada.configuration.world.lib.deployment.FileInformation;
import org.eclipse.scada.configuration.world.lib.deployment.FileOptions;
import org.eclipse.scada.utils.pkg.deb.ContentProvider;
import org.eclipse.scada.utils.pkg.deb.FileContentProvider;
import org.eclipse.scada.utils.pkg.deb.TextFileContentProvider;

public class ScoopFilesVisitor
extends SimpleFileVisitor<Path> {
    private final Path baseDir;
    private final DeploymentContext context;
    private final String targetPrefix;
    private Set<String> ignorePrefix = new HashSet<String>();
    private Set<String> execPrefix = new HashSet<String>();
    private Set<String> confPrefix = new HashSet<String>();

    public ScoopFilesVisitor(Path baseDir, DeploymentContext context, String targetPrefix) {
        this.baseDir = baseDir;
        this.context = context;
        this.targetPrefix = targetPrefix;
        this.execPrefix.add("/bin");
        this.execPrefix.add("/usr/bin");
        this.execPrefix.add("/usr/local/bin");
        this.execPrefix.add("/sbin");
        this.execPrefix.add("/usr/sbin");
        this.execPrefix.add("/usr/local/sbin");
        this.confPrefix.add("/etc");
    }

    public void setIgnorePrefix(Set<String> ignorePrefix) {
        this.ignorePrefix = ignorePrefix;
    }

    public Set<String> getIgnorePrefix() {
        return this.ignorePrefix;
    }

    public void setExecPrefix(Set<String> execPrefix) {
        this.execPrefix = execPrefix;
    }

    public Set<String> getExecPrefix() {
        return this.execPrefix;
    }

    public void setConfPrefix(Set<String> confPrefix) {
        this.confPrefix = confPrefix;
    }

    public Set<String> getConfPrefix() {
        return this.confPrefix;
    }

    @Override
    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
        Path targetPath = this.targetPrefix != null ? Paths.get(URI.create("file:" + this.targetPrefix + "/" + this.baseDir.relativize(file))) : this.baseDir.relativize(file);
        String name = targetPath.toString().replace('\\', '/');
        if (!name.startsWith("/")) {
            name = "/" + name;
        }
        boolean exec = Executables.getExecutable(file);
        boolean conf = false;
        for (String prefix : this.ignorePrefix) {
            if (!name.startsWith(prefix)) continue;
            return FileVisitResult.CONTINUE;
        }
        for (String prefix : this.execPrefix) {
            if (!name.startsWith(prefix)) continue;
            exec = true;
        }
        for (String prefix : this.confPrefix) {
            if (!name.startsWith(prefix)) continue;
            conf = true;
        }
        if (exec) {
            this.context.addFile((ContentProvider)new FileContentProvider(file.toFile()), name, new FileInformation(493, "root", "root", new FileOptions[0]));
        } else if (conf) {
            this.context.addFile((ContentProvider)new TextFileContentProvider(file.toFile()), name, new FileInformation(420, "root", "eclipsescada", FileOptions.CONFIGURATION));
        } else {
            this.context.addFile((ContentProvider)new FileContentProvider(file.toFile()), name, null);
        }
        return FileVisitResult.CONTINUE;
    }
}

