/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.world.lib.deployment.redhat;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Formatter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.scada.configuration.world.ApplicationNode;
import org.eclipse.scada.configuration.world.deployment.ChangeEntry;
import org.eclipse.scada.configuration.world.deployment.CommonDeploymentMechanism;
import org.eclipse.scada.configuration.world.deployment.RedhatDeploymentMechanism;
import org.eclipse.scada.configuration.world.deployment.StartupMechanism;
import org.eclipse.scada.configuration.world.lib.deployment.ChangeEntryComparator;
import org.eclipse.scada.configuration.world.lib.deployment.CommonHandler;
import org.eclipse.scada.configuration.world.lib.deployment.CommonPackageHandler;
import org.eclipse.scada.configuration.world.lib.deployment.FileInformation;
import org.eclipse.scada.configuration.world.lib.deployment.FileOptions;
import org.eclipse.scada.configuration.world.lib.deployment.ScriptMaker;
import org.eclipse.scada.configuration.world.lib.deployment.redhat.RedhatDeploymentContext;
import org.eclipse.scada.configuration.world.lib.deployment.startup.StartupHandler;
import org.eclipse.scada.configuration.world.lib.utils.Helper;
import org.eclipse.scada.configuration.world.lib.utils.ProcessRunner;
import org.eclipse.scada.utils.str.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LegacyRedhatHandler
extends CommonPackageHandler {
    private static final Logger logger = LoggerFactory.getLogger(LegacyRedhatHandler.class);
    private final RedhatDeploymentMechanism deploy;

    public LegacyRedhatHandler(ApplicationNode applicationNode, RedhatDeploymentMechanism deploy) {
        super(applicationNode, (CommonDeploymentMechanism)deploy);
        this.deploy = deploy;
    }

    @Override
    protected StartupMechanism getDefaultStartupMechanism() {
        return StartupMechanism.REDHAT_SYSV;
    }

    @Override
    protected String getBaseFolderName() {
        return "rpm-packages";
    }

    @Override
    protected void handleProcess(IFolder nodeDir, IProgressMonitor monitor, Map<String, String> properties) throws Exception {
        File packageFolder = this.getPackageFolder(nodeDir);
        String packageName = this.getPackageName();
        RedhatDeploymentContext context = new RedhatDeploymentContext(new File(packageFolder, "src"), packageName);
        this.setDeploymentContext(context);
        super.handleProcess(nodeDir, monitor, properties);
        File buildRoot = packageFolder.getParentFile();
        File specsDir = new File(buildRoot, "SPECS");
        specsDir.mkdirs();
        File sourcesDir = new File(buildRoot, "SOURCES");
        sourcesDir.mkdirs();
        String version = this.makeVersion((List<ChangeEntry>)this.deploy.getChanges());
        String qualifier = this.makeRelease();
        HashMap<String, String> replacements = new HashMap<String, String>();
        replacements.put("packageName", packageName);
        replacements.put("authorName", this.deploy.getMaintainer().getName());
        replacements.put("authorEmail", this.deploy.getMaintainer().getEmail());
        replacements.put("nodeName", this.applicationNode.getName() == null ? this.applicationNode.getHostName() : this.applicationNode.getName());
        replacements.put("version", version);
        replacements.put("qualifier", qualifier);
        replacements.put("changeLog", this.makeChangeLog((List<ChangeEntry>)this.deploy.getChanges()));
        replacements.put("start.apps", this.createStartApps());
        replacements.put("stop.apps", this.createStopApps());
        replacements.put("create.apps", this.makeCreate((CommonDeploymentMechanism)this.deploy));
        replacements.put("license", this.deploy.getLicense());
        replacements.put("multiuserScreen", this.deploy.isMultiUserScreen() ? "1" : "0");
        this.createDrivers(nodeDir, monitor, packageFolder, replacements);
        this.createEquinox(nodeDir.getLocation().toFile(), packageFolder, replacements, monitor);
        ScriptMaker sm = new ScriptMaker(this.getStartupHandler());
        replacements.put("postinst.scripts", String.valueOf(context.getPostInstallationString()) + sm.makePostInst());
        replacements.put("preinst.scripts", String.valueOf(context.getPreInstallationString()) + sm.makePreInst());
        replacements.put("postrem.scripts", String.valueOf(context.getPostRemovalString()) + sm.makePostRem());
        replacements.put("prerem.scripts", String.valueOf(context.getPreRemovalString()) + sm.makePreRem());
        replacements.put("files", this.makeFiles(context.getFiles(), context.getDirectories()));
        replacements.put("depends", this.makeDependencies(context.getDependencies()));
        File specFile = new File(specsDir, String.valueOf(packageName) + ".spec");
        Helper.createFile(specFile, CommonHandler.class.getResourceAsStream("templates/rpm/template.spec"), replacements, monitor);
        Helper.createFile(new File(packageFolder, "Makefile"), CommonHandler.class.getResourceAsStream("templates/rpm/Makefile"), replacements, monitor);
        if (!Boolean.parseBoolean(properties.get("skipRunDeployment"))) {
            monitor.subTask("Running 'tar'");
            File sourceFile = new File(sourcesDir, String.valueOf(packageName) + "_" + version + "." + qualifier + ".tar.gz");
            ProcessBuilder processBuilder = new ProcessBuilder("tar", "czf", sourceFile.toString(), packageName);
            processBuilder.directory(packageFolder.getParentFile());
            int rc = new ProcessRunner(processBuilder).run();
            logger.info("rc = {}", (Object)rc);
            if (rc != 0) {
                throw new IllegalStateException(String.format("command '%s' failed: %s", processBuilder.command(), rc));
            }
            monitor.subTask("Running 'rpmbuild'");
            ProcessBuilder processBuilder2 = new ProcessBuilder("rpmbuild", "--define", "_topdir " + buildRoot.toString(), "-bb", specFile.toString());
            processBuilder2.directory(packageFolder);
            int rc2 = new ProcessRunner(processBuilder2).run();
            logger.info("rc = {}", (Object)rc2);
            if (rc2 != 0) {
                throw new IllegalStateException(String.format("command '%s' failed: %s", processBuilder2.command(), rc2));
            }
        }
        nodeDir.refreshLocal(2, monitor);
    }

    private String makeDependencies(Set<String> additional) {
        HashSet<String> dependencies = new HashSet<String>();
        dependencies.add("org.eclipse.scada");
        if (this.needP2()) {
            dependencies.add("org.eclipse.scada.p2");
        }
        dependencies.add("org.eclipse.scada.deploy.p2-incubation");
        dependencies.addAll((Collection<String>)this.deploy.getAdditionalDependencies());
        dependencies.addAll(additional);
        StartupHandler sh = this.getStartupHandler();
        if (sh != null) {
            dependencies.addAll(sh.getAdditionalPackageDependencies());
        }
        HashSet<String> result = new HashSet<String>();
        for (String dep : dependencies) {
            result.add("Requires: " + dep);
        }
        return StringHelper.join(result, (String)"\n");
    }

    private String makeFiles(Map<String, FileInformation> files, Map<String, FileInformation> dirs) {
        StringBuilder line;
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, FileInformation> de : dirs.entrySet()) {
            FileInformation di = de.getValue();
            line = new StringBuilder("%dir ");
            this.writeMode(line, de.getKey(), di);
            sb.append((CharSequence)line).append('\n');
        }
        for (Map.Entry<String, FileInformation> fe : files.entrySet()) {
            FileInformation fi = fe.getValue();
            line = new StringBuilder();
            if (fi != null) {
                FileOptions[] fileOptionsArray = fi.getOptions();
                int n = fileOptionsArray.length;
                int n2 = 0;
                while (n2 < n) {
                    FileOptions fo = fileOptionsArray[n2];
                    switch (fo) {
                        case CONFIGURATION: {
                            line.append("%config ");
                        }
                    }
                    ++n2;
                }
            }
            this.writeMode(line, fe.getKey(), fi);
            sb.append((CharSequence)line).append('\n');
        }
        return sb.toString();
    }

    protected void writeMode(StringBuilder line, String targetName, FileInformation di) {
        if (di != null && (di.getMode() != null || di.getOwner() != null || di.getGroup() != null)) {
            String mode = di.getMode() == null ? "-" : String.format("%04o", di.getMode());
            String user = di.getOwner() == null ? "-" : di.getOwner();
            String group = di.getGroup() == null ? "-" : di.getGroup();
            line.append(String.format("%%attr(%s,%s,%s) ", mode, user, group));
        }
        line.append(targetName);
    }

    private String makeRelease() {
        return String.format("%1$tY%1$tm%1$td%1$tH%1$tM%1$tS", new Date());
    }

    private String makeChangeLog(List<ChangeEntry> changes) {
        ArrayList<ChangeEntry> sortedChanges = new ArrayList<ChangeEntry>(changes);
        Collections.sort(sortedChanges, new ChangeEntryComparator(true));
        StringBuilder sb = new StringBuilder();
        for (ChangeEntry entry : sortedChanges) {
            Formatter f = new Formatter(sb, Locale.ENGLISH);
            f.format("* %3$ta %3$tb %3$td %3$tY %1$s <%2$s> %4$s", entry.getAuthor().getName(), entry.getAuthor().getEmail(), entry.getDate(), entry.getVersion());
            f.close();
            sb.append('\n');
            sb.append(entry.getDescription());
            sb.append('\n');
        }
        return sb.toString();
    }

    private String makeVersion(List<ChangeEntry> changes) {
        String version = null;
        Date date = null;
        for (ChangeEntry entry : changes) {
            if (date != null && !date.before(entry.getDate())) continue;
            date = entry.getDate();
            version = entry.getVersion();
        }
        return version == null ? "0.0.0" : version;
    }
}

