/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.world.lib.deployment.redhat;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Formatter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.packagedrone.utils.rpm.build.BuilderContext;
import org.eclipse.packagedrone.utils.rpm.build.RpmBuilder;
import org.eclipse.packagedrone.utils.rpm.deps.RpmDependencyFlags;
import org.eclipse.scada.configuration.world.ApplicationNode;
import org.eclipse.scada.configuration.world.deployment.ChangeEntry;
import org.eclipse.scada.configuration.world.deployment.CommonDeploymentMechanism;
import org.eclipse.scada.configuration.world.deployment.RedhatDeploymentMechanism;
import org.eclipse.scada.configuration.world.deployment.StartupMechanism;
import org.eclipse.scada.configuration.world.lib.deployment.ChangeEntryComparator;
import org.eclipse.scada.configuration.world.lib.deployment.CommonPackageHandler;
import org.eclipse.scada.configuration.world.lib.deployment.FileInformation;
import org.eclipse.scada.configuration.world.lib.deployment.FileOptions;
import org.eclipse.scada.configuration.world.lib.deployment.ScriptMaker;
import org.eclipse.scada.configuration.world.lib.deployment.redhat.RedhatDeploymentContext;
import org.eclipse.scada.configuration.world.lib.deployment.startup.StartupHandler;

public class RedhatHandler
extends CommonPackageHandler {
    private final RedhatDeploymentMechanism deploy;

    public RedhatHandler(ApplicationNode applicationNode, RedhatDeploymentMechanism deploy) {
        super(applicationNode, (CommonDeploymentMechanism)deploy);
        this.deploy = deploy;
    }

    @Override
    protected StartupMechanism getDefaultStartupMechanism() {
        return StartupMechanism.REDHAT_SYSV;
    }

    @Override
    protected String getBaseFolderName() {
        return "rpm-packages";
    }

    @Override
    protected void handleProcess(IFolder nodeDir, IProgressMonitor monitor, Map<String, String> properties) throws Exception {
        File packageFolder = this.getPackageFolder(nodeDir);
        String packageName = this.getPackageName();
        File tempDir = new File(packageFolder, "src");
        final RedhatDeploymentContext context = new RedhatDeploymentContext(tempDir, packageName);
        this.setDeploymentContext(context);
        super.handleProcess(nodeDir, monitor, properties);
        Path outputDir = nodeDir.getLocation().toFile().toPath();
        Files.createDirectories(outputDir, new FileAttribute[0]);
        String version = this.makeVersion((List<ChangeEntry>)this.deploy.getChanges());
        String qualifier = this.makeRelease();
        String nodeName = this.applicationNode.getName() == null ? this.applicationNode.getHostName() : this.applicationNode.getName();
        Throwable throwable = null;
        Object var13_14 = null;
        try (RpmBuilder builder = new RpmBuilder(packageName, version, qualifier, outputDir);){
            RpmBuilder.PackageInformation pinfo = builder.getInformation();
            pinfo.setLicense(this.deploy.getLicense());
            pinfo.setSummary(String.format("Eclipse NeoSCADA Configuration for \"%s\"", nodeName));
            pinfo.setDescription(String.format("This is the configuration package for node \"%s\".", nodeName));
            pinfo.setPackager(String.format("%s <%s>", this.deploy.getMaintainer().getName(), this.deploy.getMaintainer().getEmail()));
            pinfo.setGroup("Application/System");
            HashMap<String, String> replacements = new HashMap<String, String>();
            replacements.put("packageName", packageName);
            replacements.put("authorName", this.deploy.getMaintainer().getName());
            replacements.put("authorEmail", this.deploy.getMaintainer().getEmail());
            replacements.put("nodeName", nodeName);
            replacements.put("version", version);
            replacements.put("qualifier", qualifier);
            replacements.put("changeLog", this.makeChangeLog((List<ChangeEntry>)this.deploy.getChanges()));
            this.createDrivers(nodeDir, monitor, packageFolder, replacements);
            this.createEquinox(nodeDir.getLocation().toFile(), packageFolder, replacements, monitor);
            ScriptMaker sm = new ScriptMaker(this.getStartupHandler());
            builder.setPreInstallationScript(String.valueOf(this.createStopApps()) + context.getPreInstallationString() + sm.makePreInst());
            builder.setPostInstallationScript(String.valueOf(context.getPostInstallationString()) + sm.makePostInst() + this.makeMultiScreenScript() + this.makeCreate((CommonDeploymentMechanism)this.deploy) + this.createStartApps());
            builder.setPreRemoveScript(String.valueOf(this.createStopApps()) + context.getPreRemovalString() + sm.makePreRem());
            builder.setPostRemoveScript(String.valueOf(context.getPostRemovalString()) + sm.makePostRem());
            for (String dep : this.makeDependencies(context.getDependencies())) {
                builder.addRequirement(dep, null, new RpmDependencyFlags[0]);
            }
            final BuilderContext ctx = builder.newContext();
            for (Map.Entry<String, FileInformation> dir : new TreeMap<String, FileInformation>(context.getDirectories()).entrySet()) {
                ctx.addDirectory(dir.getKey(), BuilderContext.simpleDirectoryProvider().customize(fi -> RedhatHandler.applyFileInformation(fi, (FileInformation)dir.getValue(), true)));
            }
            final Path base = tempDir.toPath();
            Files.walkFileTree(base, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Path localPath = Paths.get("/", new String[0]).resolve(base.relativize(file)).normalize();
                    String targetName = localPath.toString().replace(File.separator, "/");
                    FileInformation i = context.getFiles().get(targetName);
                    ctx.addFile(targetName, file, BuilderContext.simpleFileProvider().customize(fi -> RedhatHandler.applyFileInformation(fi, i, true)));
                    return FileVisitResult.CONTINUE;
                }
            });
            builder.build();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        nodeDir.refreshLocal(2, monitor);
    }

    private static void applyFileInformation(org.eclipse.packagedrone.utils.rpm.build.FileInformation fi, FileInformation i, boolean directory) {
        if (i == null) {
            return;
        }
        if (i.getMode() != null) {
            fi.setMode(i.getMode().shortValue());
        }
        if (i.getOwner() == null) {
            fi.setUser(i.getOwner());
        }
        if (i.getGroup() != null) {
            fi.setGroup(i.getGroup());
        }
        if (!directory && i.getOptions() != null) {
            FileOptions[] fileOptionsArray = i.getOptions();
            int n = fileOptionsArray.length;
            int n2 = 0;
            while (n2 < n) {
                FileOptions opt = fileOptionsArray[n2];
                switch (opt) {
                    case CONFIGURATION: {
                        fi.setConfiguration(true);
                    }
                }
                ++n2;
            }
        }
    }

    private String makeMultiScreenScript() {
        if (this.deploy.isMultiUserScreen()) {
            return "test -f ~eclipsescada/.screenrc && echo \"multiuser on\nacladd root\" > ~eclipsescada/.screenrc";
        }
        return "";
    }

    private Set<String> makeDependencies(Set<String> additional) {
        HashSet<String> dependencies = new HashSet<String>();
        dependencies.add("org.eclipse.scada");
        if (this.needP2()) {
            dependencies.add("org.eclipse.scada.p2");
        }
        dependencies.add("org.eclipse.scada.deploy.p2-incubation");
        dependencies.addAll((Collection<String>)this.deploy.getAdditionalDependencies());
        dependencies.addAll(additional);
        StartupHandler sh = this.getStartupHandler();
        if (sh != null) {
            dependencies.addAll(sh.getAdditionalPackageDependencies());
        }
        return dependencies;
    }

    private String makeRelease() {
        return String.format("%1$tY%1$tm%1$td%1$tH%1$tM%1$tS", new Date());
    }

    private String makeChangeLog(List<ChangeEntry> changes) {
        ArrayList<ChangeEntry> sortedChanges = new ArrayList<ChangeEntry>(changes);
        Collections.sort(sortedChanges, new ChangeEntryComparator(true));
        StringBuilder sb = new StringBuilder();
        for (ChangeEntry entry : sortedChanges) {
            Formatter f = new Formatter(sb, Locale.ENGLISH);
            f.format("* %3$ta %3$tb %3$td %3$tY %1$s <%2$s> %4$s", entry.getAuthor().getName(), entry.getAuthor().getEmail(), entry.getDate(), entry.getVersion());
            f.close();
            sb.append('\n');
            sb.append(entry.getDescription());
            sb.append('\n');
        }
        return sb.toString();
    }

    private String makeVersion(List<ChangeEntry> changes) {
        String version = null;
        Date date = null;
        for (ChangeEntry entry : changes) {
            if (date != null && !date.before(entry.getDate())) continue;
            date = entry.getDate();
            version = entry.getVersion();
        }
        return version == null ? "0.0.0" : version;
    }
}

