/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.world.lib.deployment.startup;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.scada.configuration.world.lib.deployment.Contents;
import org.eclipse.scada.configuration.world.lib.deployment.DeploymentContext;
import org.eclipse.scada.configuration.world.lib.deployment.FileInformation;
import org.eclipse.scada.configuration.world.lib.deployment.FileOptions;
import org.eclipse.scada.configuration.world.lib.deployment.startup.AbstractStartupHandler;

public class SystemdHandler
extends AbstractStartupHandler {
    private static final Pattern ALT_PATTERN = Pattern.compile("\\@\\@(.*?)\\@\\@");

    @Override
    public void createDriver(DeploymentContext context, String driverName, Map<String, String> replacements, IProgressMonitor monitor) throws Exception {
        context.addFile(Contents.createContent(SystemdHandler.class.getResourceAsStream("templates/systemd/driver.service"), replacements, ALT_PATTERN), "/usr/lib/systemd/system/scada.driver." + driverName + ".service", new FileInformation(420, null, null, FileOptions.CONFIGURATION));
        context.addFile(Contents.createContent(SystemdHandler.class.getResourceAsStream("templates/systemd/driver.launcher.sh"), replacements, ALT_PATTERN), "/usr/bin/scada.driver." + driverName + ".launcher", new FileInformation(493, null, null, new FileOptions[0]));
    }

    @Override
    public void createEquinox(DeploymentContext context, String appName, Map<String, String> replacements, IProgressMonitor monitor) throws Exception {
        context.addFile(Contents.createContent(SystemdHandler.class.getResourceAsStream("templates/systemd/p2.service"), replacements, ALT_PATTERN), "/usr/lib/systemd/system/scada.app." + appName + ".service", new FileInformation(420, null, null, FileOptions.CONFIGURATION));
        context.addFile(Contents.createContent(SystemdHandler.class.getResourceAsStream("templates/systemd/p2.launcher.sh"), replacements, ALT_PATTERN), "/usr/bin/scada.app." + appName + ".launcher", new FileInformation(493, null, null, new FileOptions[0]));
    }

    @Override
    public String[] startDriverCommand(String driverName) {
        return new String[]{String.format("systemctl enable \"scada.driver.%s\".service", driverName), String.format("systemctl start \"scada.driver.%s\"", driverName)};
    }

    @Override
    public String[] stopDriverCommand(String driverName) {
        return new String[]{String.format("systemctl disable \"scada.driver.%s\".service", driverName), String.format("systemctl stop \"scada.driver.%s\"", driverName)};
    }

    @Override
    public String[] startEquinoxCommand(String appName) {
        return new String[]{String.format("systemctl enable \"scada.app.%s\".service", appName), String.format("systemctl start \"scada.app.%s\"", appName)};
    }

    @Override
    public String[] stopEquinoxCommand(String appName) {
        return new String[]{String.format("systemctl --no-reload disable \"scada.app.%s\".service", appName), String.format("systemctl stop \"scada.app.%s\".service", appName)};
    }

    @Override
    public String[] postinstCommands() {
        return new String[]{"systemctl daemon-reload"};
    }

    @Override
    public String[] postremCommands() {
        return new String[]{"systemctl daemon-reload"};
    }

    @Override
    public Set<String> getAdditionalPackageDependencies() {
        return Collections.singleton("screen");
    }
}

