/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.world.lib.deployment.wix;

import java.io.File;
import java.io.StringReader;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class XMLBase {
    private final DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();

    protected Element createElement(Element parent, String name) {
        Element ele = parent.getOwnerDocument().createElement(name);
        parent.appendChild(ele);
        return ele;
    }

    protected Element createElement(Element parent, String prefix, String name, String namespaceURI) {
        Element ele = parent.getOwnerDocument().createElementNS(namespaceURI, String.valueOf(prefix) + ":" + name);
        parent.appendChild(ele);
        return ele;
    }

    protected Element createElementWithText(Element parent, String name, String text) {
        Element ele = parent.getOwnerDocument().createElement(name);
        parent.appendChild(ele);
        ele.appendChild(parent.getOwnerDocument().createTextNode(text));
        return ele;
    }

    protected Element parseFragment(String string) throws Exception {
        DocumentBuilder db = this.dbf.newDocumentBuilder();
        InputSource is = new InputSource(new StringReader(string));
        Document doc = db.parse(is);
        return doc.getDocumentElement();
    }

    protected void appendFragment(Element parent, String fragment) throws Exception {
        Element ele = this.parseFragment(fragment);
        ele = (Element)parent.getOwnerDocument().adoptNode(ele);
        parent.appendChild(ele);
    }

    protected void appendFragment(Element parent, URL url) throws Exception {
        DocumentBuilder db = this.dbf.newDocumentBuilder();
        InputSource is = new InputSource(url.openStream());
        Document doc = db.parse(is);
        Element ele = doc.getDocumentElement();
        ele = (Element)parent.getOwnerDocument().adoptNode(ele);
        parent.appendChild(ele);
    }

    protected void storeXmlDocument(Document doc, File file) throws TransformerFactoryConfigurationError, TransformerConfigurationException, TransformerException {
        file.getParentFile().mkdirs();
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        DOMSource source = new DOMSource(doc);
        StreamResult result = new StreamResult(file);
        transformer.transform(source, result);
    }

    protected Document createXmlDocument() throws ParserConfigurationException {
        DocumentBuilder db = this.dbf.newDocumentBuilder();
        Document doc = db.newDocument();
        return doc;
    }
}

