/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.world.lib.oscar;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class OscarContext {
    private final Map<String, Map<String, Map<String, String>>> data = OscarContext.createMap();
    private final Map<String, Set<String>> ignoreFields = OscarContext.createMap();

    private static boolean useTreeMaps() {
        return !Boolean.getBoolean("org.eclipse.scada.configuration.world.lib.oscar.useHashMaps");
    }

    private static <T> Map<String, T> createMap() {
        return OscarContext.createMap(-1);
    }

    private static <T> Map<String, T> createMap(int initialHashSize) {
        if (OscarContext.useTreeMaps()) {
            return new TreeMap();
        }
        if (initialHashSize > 0) {
            return new HashMap(initialHashSize);
        }
        return new HashMap();
    }

    private static Set<String> createSet() {
        if (OscarContext.useTreeMaps()) {
            return new TreeSet<String>();
        }
        return new HashSet<String>();
    }

    public void addIgnoreField(String factoryId, String fieldName) {
        Set<String> fields = this.ignoreFields.get(factoryId);
        if (fields == null) {
            fields = OscarContext.createSet();
            this.ignoreFields.put(factoryId, fields);
        }
        fields.add(fieldName);
    }

    public void addIgnoreFields(String factoryId, String ... fieldNames) {
        Set<String> fields = this.ignoreFields.get(factoryId);
        if (fields == null) {
            fields = OscarContext.createSet();
            this.ignoreFields.put(factoryId, fields);
        }
        fields.addAll(Arrays.asList(fieldNames));
    }

    public void addData(String factoryId, String configurationId, Map<String, String> data) {
        Map<String, Map<String, String>> factoryData = this.data.get(factoryId);
        if (factoryData == null) {
            factoryData = OscarContext.createMap(5000);
            this.data.put(factoryId, factoryData);
        }
        if (OscarContext.useTreeMaps() && !(data instanceof TreeMap)) {
            factoryData.put(configurationId, new TreeMap<String, String>(data));
        } else {
            factoryData.put(configurationId, data);
        }
    }

    public Map<String, Map<String, Map<String, String>>> getData() {
        return this.data;
    }

    public Map<String, Set<String>> getIgnoreFields() {
        return this.ignoreFields;
    }
}

